<?php 
$formula_items = json_decode($items_formula['items'],true);
foreach($formula_items as $row){
$item_data = fetch_table_where('items','uid',$row['item'],true);

$item_avg_cost = $item_data['_avg_cost'];
$item_currency = $item_data['currency'];
$item_currency_equalance = $item_data['currency_usd_equalance'];
if($item_currency != $production_currency['uid'])
{
	$item_avg_cost = amount_conversion($item_avg_cost, $item_currency_equalance, $production_currency['usd_equalance']);
}

$item_stats = json_decode($item_data['stats'],true);
$item_warehouses = [];
if(!empty($item_stats['avail_units']))
{
	foreach($item_stats['avail_units'] as $key => $iware)
	{
		$item_warehouses[] = $key;
	}
}
?>
	<div class="row new-production-formula-items-row">
		<div class="col-md-3 pointer-none">
		    <div class="form-group">
		        <select class="form-control chosen-select cv-required" name="raw_item[]">
		            <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_raw_item'); ?> --</option>
		            <?php foreach($branch_items as $itrow){ if($itrow['type'] == 'sales'){continue;} ?>
		                <option <?php if($row['item'] == $itrow['uid']){echo "selected='selected'";}?> value="<?= $itrow['uid']; ?>"><?= $itrow['name']; ?></option>
		            <?php } ?>
		        </select>
		    </div>
		</div>
		<div class="col-md-3">
		    <div class="form-group">
		        <select class="form-control chosen-select cv-required" name="raw_warehouse[]">
		            <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_new_add_input_raw_warehouse'); ?> --</option>
		            <?php foreach($warehouses as $irow){ if(!in_array($irow['uid'], $item_warehouses)){continue;} ?>
		                <option value="<?= $irow['uid']; ?>"><?= $irow['name']; ?></option>
		            <?php } ?>
		        </select>
		    </div>
		</div>
		<div class="col-md-3 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control new-production-raw-item-qty cv-required" name="raw_qty[]">
			</div>
		</div>
		<div class="col-md-3 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control new-production-raw-item-cost cv-required" name="raw_cost[]" value="<?= round_decimels_digits_3($item_avg_cost); ?>">
			    <input type="hidden" class="form-control new-production-raw-item-percentage" name="raw_percentage[]" value="<?= $row['percentage']; ?>">
			</div>
		</div>
	</div>
<?php } ?>

<hr>
<?php 
	
	$expenses_all_in_main_currency = [];
	foreach($currencies as $currency)
	{
	    $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray());
	    $expenses = DB::table('expenses')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first();
	    $expenses_balance = $expenses->balance;
	    $expenses_all_in_main_currency[] = amount_conversion($expenses_balance, (float)$currency['usd_equalance'], $production_currency['usd_equalance']);
	}
?>

<div class="row">
	<div class="col-md-2 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_new_add_input_system_expenses'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control new-production-total-system-expenses" name="total_system_expenses" value="<?= round_decimels_digits_3(array_sum($expenses_all_in_main_currency)); ?>" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_system_expenses'); ?>">
		</div>
	</div>

	<div class="col-md-2">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_new_add_input_used_expenses'); ?> </label>
		    <input type="text" class="form-control new-production-used-expenses" name="used_expenses" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_used_expenses'); ?>">
		</div>
	</div>

	<div class="col-md-2 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_new_add_input_total_cost'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control new-production-total-cost cv-required" name="total_cost" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_total_cost'); ?>">
		</div>
	</div>

	<div class="col-md-3 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_new_add_input_total_real_cost'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control new-production-total-real-cost cv-required" name="total_real_cost" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_total_real_cost'); ?>">
		</div>
	</div>

	<div class="col-md-3 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_new_add_input_per_item_cost'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control new-production-per-item-produced-cost cv-required" name="per_item_cost" placeholder="<?= print_lang($app_lang,'mod_production_new_add_input_per_item_cost'); ?>">
		</div>
	</div>
</div>