<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_production_new_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_production_new_view_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_production') === TRUE){ ?>
                <a href="<?= url('/new-production/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_production_new_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_production_new_view_title_listing'); ?></h2>

                    <form id="new-production-search-form" action="<?= url('/new-production'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="item">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'item'); ?> --</option>
                                                <?php foreach($items as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search display-none"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_total_weight'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_production_new_view_thead_expenses'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'mod_production_new_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>s
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= $row['qty']; ?></td>
                                        <td><?= $row['per_item_cost']; ?></td>
                                        <td><?= $row['weight']; ?></td>
                                        <td><?= $row['total_weight']; ?></td>
                                        <td><?= $row['used_expenses']; ?></td>
                                        <td>
                                            <?php if(check_user_access('add_production') === TRUE){ ?>
                                                <a href="<?= url('/new-production/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem display-none"><i class="fa fa-external-link">&nbsp; </i><?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_production') === TRUE){ ?>
                                                <a href="<?= url('/new-production/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_production') === TRUE){ ?>
                                                <a href="<?= url('/new-production/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>