<?php if(is_customer_user() === true){ ?>
<style type="text/css">
  .navbar-default.navbar-static-side{display: none !important;}
  #page-wrapper{width: 100%; margin: 0;}
  .footer.fixed{margin: 0;}
</style>
<?php } ?>
<style type="text/css">
    .chosen-container a.chosen-single{line-height: 24px !important;}
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_bookings_edit_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/bookings'); ?>"><?= print_lang($app_lang,'mod_bookings_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_bookings_edit_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="temp-bookings-form">

                    <div class="row fixed-fields-row pointer-none" style="margin-bottom: 5px;">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_bookings_add_currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_bookings_add_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option <?php if($editing_data['currency'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_bookings_add_expected_date'); ?></label>
                                <?php $edate = display_true_date($editing_data['expected_date']); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="temp_pdate" value="<?= true_date_for_inputs($edate); ?>" placeholder="<?= print_lang($app_lang,'mod_trans_in_add_input_date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="temp_pdate" value="<?= date("Y-m-d",strtotime(true_date_for_inputs($edate))); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_bookings_add_memo'); ?></label>
                                <textarea style="height: 35px;" class="form-control temp_p_memo_edit" name="temp_memo" rows="1" placeholder="<?= print_lang($app_lang,'mod_bookings_add_memo'); ?>"><?= $editing_data['memo']; ?></textarea>
                            </div>
                        </div>
                    </div>                    

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_bookings_add_item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_item">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_bookings_add_item'); ?> --</option>
                                    <?php foreach($items as $row){
                                        $item_stats = json_decode($row['stats'],true);
                                        $item_last_batch_tp = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',active_branch_id())->where('item',$row['uid'])->where('module','!=','sales')->where('module','!=','damage')->where('module','!=','transfer_out')->whereNotNull('sale_price')->orderBy('module_created_at','desc')->get()->first());
                                        $item_tp = (float)$item_last_batch_tp['sale_price'];
                                    ?>
                                        <option value="<?= $row['uid']; ?>" data-tp="<?= $item_tp; ?>" data-last-cost="<?= $item_stats['last_cost']; ?>" data-last-profit="<?= $item_stats['last_profit']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name'].', '.$row['item_id']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_bookings_add_qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="temp_qty" placeholder="<?= print_lang($app_lang,'mod_bookings_add_qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_bookings_add_tp'); ?><strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="temp_tp" readonly placeholder="<?= print_lang($app_lang,'mod_bookings_add_tp'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'mod_bookings_add_to_list'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="bookings-form" action="<?php echo url('/bookings/update').'/'.$editing_data['uid']; ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_add_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_add_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_add_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_add_thead_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_add_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="bookings-table-body">
                                <?php
                                    $bookings_items_db = json_decode($editing_data['items'],true);
                                    if(count($bookings_items_db) > 0){
                                ?>
                                <?php foreach($bookings_items_db as $row){ ?>
                                    <tr class="text-center bookings-row">
                                        <td class="td-self-bookings">
                                            <?= array_key_exists($row['item'], $items) ? $items[$row['item']]['name'] : NULL; ?>
                                            <input type="hidden" name="item[]" value="<?= $row['item']; ?>">
                                            <input type="hidden" name="currency[]" value="<?= $editing_data['currency']; ?>">
                                            <input type="hidden" name="pdate[]" value="<?= true_date_for_inputs($edate); ?>">
                                            <input type="hidden" name="memo[]" value="<?= $editing_data['memo']; ?>">
                                        </td>
                                        <td class="bookings-qty">
                                            <span><?= amount_number_format((float)$row['qty']); ?></span> 
                                            <input type="hidden" name="qty[]" value="<?= (float)$row['qty']; ?>">
                                        </td>
                                        <td class="bookings-tp">
                                            <span><?= amount_number_format((float)$row['tp']); ?></span> 
                                            <input type="hidden" name="tp[]" value="<?= (float)$row['tp']; ?>">
                                        </td>
                                        <td class="bookings-total">
                                            <span><?= amount_number_format((float)$row['total']); ?></span> 
                                            <input type="hidden" name="total_r[]" value="<?= (float)$row['total']; ?>">
                                        </td>
                                        <td style="width: 40px;"><a class="btn btn-danger btn-sm bookings-del-trigger" href="javascript:void(0);"><i class="fa fa-trash"></i></a></td>
                                    </tr>
                                <?php }} ?>
                            </tbody>
                        </table>    
                    </div>
                </div>

                <div class="col-md-12 bookings-totals-col">
                    <div class="row">
                        <div class="col-md-12 bookings-total-cel bookings-total-amount-row">
                            <strong><?= print_lang($app_lang,'mod_bookings_add_total'); ?>: </strong>
                            <span class="cals-span"><?= amount_number_format((float)$editing_data['total']); ?></span>
                            <input class="cals-input" type="hidden" name="total" value="<?= (float)$editing_data['total']; ?>">
                        </div>

                        <div class="col-md-12" style="margin-top: 20px;">
                            <input type="submit" style="width: 100%;" class="btn btn-primary" value="<?= print_lang($app_lang,'mod_bookings_edit_update'); ?>">
                        </div>
                    </div>
                </div>

            </div>
        </form>

    </div>

</div>