<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_orders_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_orders_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_orders_view_title'); ?></h2>

                    <form id="orders-search-form" action="<?= url('/orders'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <input type="hidden" name="status" value="<?= $status; ?>">
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'client'); ?></label>
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_orders_view_thead_status'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'mod_orders_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                ?>
                                    <tr class="text-center orders-approval-row">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td>
                                            <?= array_key_exists($row['customer'], $clients) ? $clients[$row['customer']]['name'] : NULL; ?>
                                        </td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= round_decimels_digits($row['total']); $total[] = (float)$row['total']; ?></td>
                                        <td>
                                            <?php 
                                            if($row['status'] == 'approved')
                                            {
                                                echo '<span class="badge badge-primary">'.print_lang($app_lang,'mod_orders_view_thead_status_'.$row['status']).'</span>';
                                            }
                                            if($row['status'] == 'pending')
                                            {
                                                echo '<span class="badge badge-warning">'.print_lang($app_lang,'mod_orders_view_thead_status_'.$row['status']).'</span>';
                                            }
                                            if($row['status'] == 'rejected')
                                            {
                                                echo '<span class="badge badge-danger">'.print_lang($app_lang,'mod_orders_view_thead_status_'.$row['status']).'</span>';
                                            }
                                            ?>
                                        </td>

                                        <td>
                                            <?php if(check_user_access('orders_view_invoice') === TRUE){ ?>
                                                <a href="<?= url('/bookings/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i>&nbsp;<?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('process_order') === TRUE){ ?>
                                                <a href="<?= url('/orders/process').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i>&nbsp;<?= print_lang($app_lang,'process'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_order') === TRUE){ ?>
                                                <a href="<?= url('/bookings/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total)); ?></strong></td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>