<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_payment_deduction'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/payment-deductions'); ?>"><?= print_lang($app_lang,'payment_deductions'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_payment_deduction'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="payment-deductions-form" action="<?php echo url('/payment-deductions/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="amount" value="<?= $editing_data['amount']; ?>" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php $pdate = display_true_date($editing_data['pdate']); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="pdate" value="<?= true_date_for_inputs($pdate); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="pdate" value="<?= true_date_for_inputs($pdate); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'scan_copy'); ?></label>
                                <input type="file" class="form-control" name="scan_copy">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-currency="<?= $row['currency']; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" <?php if($editing_data['project'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_currency_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="project_according_amount" value="<?= $editing_data['project_according_amount']; ?>" placeholder="<?= print_lang($app_lang,'project_currency_amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'from_account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="from_account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['from_account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'to_account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="to_account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'cashbook' OR $row['type'] == 'bank'){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($editing_data['to_account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <textarea rows="4" class="form-control" name="comments" placeholder="<?= print_lang($app_lang,'comments'); ?>"><?= $editing_data['comments']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/payment-deductions'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>