<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'new_payslip'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/payslips'); ?>"><?= print_lang($app_lang,'payslips'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_payslip'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="payslips-form" action="<?php echo url('/payslips/save'); ?>">

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <input type="date" class="form-control" name="pay_date">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="employee">
                                    <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'employee'); ?> --</option>
                                    <?php foreach($employees as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-father-name="<?= $row['father_name']; ?>" data-salary="<?= $row['stats']['salary']; ?>" data-advance="<?= $row['stats']['advance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'father_name'); ?></label>
                                <input type="text" class="form-control pointer-none" name="father_name" placeholder="<?= print_lang($app_lang,'father_name'); ?>">
                            </div>
                        </div>
                    </div>

                    

                    <div class="row" style="margin-top: 10px;">
                        <div class="col-md-12">
                            <h3><?= print_lang($app_lang,'salary_details'); ?></h3>
                        </div>
                    </div>

                    <div class="row" style="margin-top: 20px; margin-bottom: 20px;">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-2">
                                    <span style="display: inline-block; position: relative; top: 7px;"><?= print_lang($app_lang,'salary'); ?></span>
                                </div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <input type="number" class="form-control pointer-none" name="basic_salary" placeholder="<?= print_lang($app_lang,'basic_salary'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <a href="javascript:void(0);" id="add-earning-trigger" class="btn btn-primary"><i class="fa fa-plus"></i></a>
                                </div>
                            </div>
                            <div id="earnings-rows-wrapper">
                                
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-2">
                                    <span style="display: inline-block; position: relative; top: 7px;"><?= print_lang($app_lang,'advance'); ?></span>
                                </div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <input type="number" class="form-control pointer-none" name="advance_amount" placeholder="<?= print_lang($app_lang,'advance_amount'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <a href="javascript:void(0);" id="add-deduction-trigger" class="btn btn-primary"><i class="fa fa-plus"></i></a>
                                </div>
                            </div>
                            <div id="deductions-rows-wrapper">
                                
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_earning'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_earning" placeholder="<?= print_lang($app_lang,'total_earning'); ?>">
                            </div>
                        </div>
                        <div class="col-md-1 custom-col" style="padding: 0;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_month_days'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_month_days" placeholder="<?= print_lang($app_lang,'total_month_days'); ?>">
                            </div>
                        </div>
                        <div class="col-md-1 custom-col" style="padding: 0;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_absents'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_absents" placeholder="<?= print_lang($app_lang,'total_absents'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_deduction_absents'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_deduction_absents" placeholder="<?= print_lang($app_lang,'total_deduction_absents'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_deduction'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_deduction" placeholder="<?= print_lang($app_lang,'total_deduction'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'net_salary'); ?></label>
                                <input type="number" class="form-control pointer-none" name="net_salary" placeholder="<?= print_lang($app_lang,'net_salary'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'cashbook' OR $row['type'] == 'bank'){ ?>
                                            <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'narration'); ?></label>
                                <textarea class="form-control" name="narration" placeholder="<?= print_lang($app_lang,'narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/payslips'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>