<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_payslip'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/payslips'); ?>"><?= print_lang($app_lang,'payslips'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_payslip'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="payslips-form" action="<?php echo url('/payslips/update').'/'.$editing_data['uid']; ?>">

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <input type="date" class="form-control" name="pay_date" value="<?= $editing_data['pay_date']; ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'month'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="pay_month">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'month'); ?> --</option>
                                    <option value="1" <?php if($editing_data['pay_month'] == '1'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'january'); ?></option>
                                    <option value="2" <?php if($editing_data['pay_month'] == '2'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'february'); ?></option>
                                    <option value="3" <?php if($editing_data['pay_month'] == '3'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'march'); ?></option>
                                    <option value="4" <?php if($editing_data['pay_month'] == '4'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'april'); ?></option>
                                    <option value="5" <?php if($editing_data['pay_month'] == '5'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'may'); ?></option>
                                    <option value="6" <?php if($editing_data['pay_month'] == '6'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'june'); ?></option>
                                    <option value="7" <?php if($editing_data['pay_month'] == '7'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'july'); ?></option>
                                    <option value="8" <?php if($editing_data['pay_month'] == '8'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'august'); ?></option>
                                    <option value="9" <?php if($editing_data['pay_month'] == '9'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'september'); ?></option>
                                    <option value="10" <?php if($editing_data['pay_month'] == '10'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'October'); ?></option>
                                    <option value="11" <?php if($editing_data['pay_month'] == '11'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'November'); ?></option>
                                    <option value="12" <?php if($editing_data['pay_month'] == '12'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'December'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'year'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="pay_year">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'year'); ?> --</option>
                                    <?php $current_year = date('Y'); for($y = 0; $y < 5; $y++){ $run_year = $current_year++; ?>
                                      <option value="<?= $run_year; ?>" <?php if($editing_data['pay_year'] == $run_year){ echo 'selected="selected"'; } ?>><?= $run_year; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group pointer-none">
                                <label><?= print_lang($app_lang,'employee'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="employee">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'employee'); ?> --</option>
                                    <?php $father_name = NULL; foreach($employees as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['employee'] == $row['uid']){ $father_name = $row['father_name']; echo 'selected="selected"'; } ?> data-father-name="<?= $row['father_name']; ?>" data-salary="<?= $row['stats']['advance']; ?>" data-advance="<?= $row['stats']['advance']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'father_name'); ?></label>
                                <input type="text" class="form-control pointer-none" name="father_name" value="<?= $father_name; ?>" placeholder="<?= print_lang($app_lang,'father_name'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-top: 10px;">
                        <div class="col-md-12">
                            <h3><?= print_lang($app_lang,'salary_details'); ?></h3>
                        </div>
                    </div>

                    <div class="row" style="margin-top: 20px; margin-bottom: 20px;">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-2">
                                    <span style="display: inline-block; position: relative; top: 7px;"><?= print_lang($app_lang,'salary'); ?></span>
                                </div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <input type="number" class="form-control pointer-none" name="basic_salary" value="<?= $editing_data['basic_salary']; ?>" placeholder="<?= print_lang($app_lang,'basic_salary'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <a href="javascript:void(0);" id="add-earning-trigger" class="btn btn-primary"><i class="fa fa-plus"></i></a>
                                </div>
                            </div>
                            <div id="earnings-rows-wrapper">
                                <?php
                                $earnings = json_decode($editing_data['earnings'],true);
                                foreach($earnings as $row){
                                ?>
                                    <div class="row earning-row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" class="form-control earning-name" name="earning_name[]" value="<?= $row['name']; ?>" placeholder="<?= print_lang($app_lang,'earning_name'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="number" class="form-control earning-amount" name="earning_amount[]" value="<?= $row['amount']; ?>" placeholder="<?= print_lang($app_lang,'earning_amount'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <a href="javascript:void(0);" class="btn btn-danger del-earning-trigger"><i class="fa fa-trash"></i></a>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-2">
                                    <span style="display: inline-block; position: relative; top: 7px;"><?= print_lang($app_lang,'advance'); ?></span>
                                </div>
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <input type="number" class="form-control pointer-none" name="advance_amount" value="<?= $editing_data['advance_amount']; ?>" placeholder="<?= print_lang($app_lang,'advance_amount'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <a href="javascript:void(0);" id="add-deduction-trigger" class="btn btn-primary"><i class="fa fa-plus"></i></a>
                                </div>
                            </div>
                            <div id="deductions-rows-wrapper">
                                <?php
                                $deductions = json_decode($editing_data['deductions'],true);
                                foreach($deductions as $row){
                                ?>
                                    <div class="row deduction-row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" class="form-control deduction-name" name="deduction_name[]" value="<?= $row['name']; ?>" placeholder="<?= print_lang($app_lang,'deduction_name'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="number" class="form-control deduction-amount" name="deduction_amount[]" value="<?= $row['amount']; ?>" placeholder="<?= print_lang($app_lang,'deduction_amount'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <a href="javascript:void(0);" class="btn btn-danger del-deduction-trigger"><i class="fa fa-trash"></i></a>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_earning'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_earning" value="<?= $editing_data['total_earning']; ?>" placeholder="<?= print_lang($app_lang,'total_earning'); ?>">
                            </div>
                        </div>
                        <div class="col-md-1 custom-col" style="padding: 0;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_month_days'); ?></label>
                                <input type="number" class="form-control pointer-none" value="<?= $editing_data['total_month_days']; ?>" name="total_month_days" placeholder="<?= print_lang($app_lang,'total_month_days'); ?>">
                            </div>
                        </div>
                        <div class="col-md-1 custom-col" style="padding: 0;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_absents'); ?></label>
                                <input type="number" class="form-control pointer-none" value="<?= $editing_data['total_absents']; ?>" name="total_absents" placeholder="<?= print_lang($app_lang,'total_absents'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_deduction_absents'); ?></label>
                                <input type="number" class="form-control pointer-none" value="<?= $editing_data['total_deduction_absents']; ?>" name="total_deduction_absents" placeholder="<?= print_lang($app_lang,'total_deduction_absents'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'total_deduction'); ?></label>
                                <input type="number" class="form-control pointer-none" name="total_deduction" value="<?= $editing_data['total_deduction']; ?>" placeholder="<?= print_lang($app_lang,'total_deduction'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'net_salary'); ?></label>
                                <input type="number" class="form-control pointer-none" name="net_salary" value="<?= $editing_data['net_salary']; ?>" placeholder="<?= print_lang($app_lang,'net_salary'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'cashbook' OR $row['type'] == 'bank'){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($editing_data['account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'narration'); ?></label>
                                <textarea class="form-control" name="narration" placeholder="<?= print_lang($app_lang,'narration'); ?>"><?= $editing_data['narration']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/payslips'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>