<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'payslips'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'payslips'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_payslips') === TRUE){ ?>
                <a href="<?php echo url('/payslips/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'new_payslip'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'payslips_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'employee'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_earning'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_month_days'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_absents'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total_deduction'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'net_salary'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    <th class="text-center" style="min-width:200px; max-width:200px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['pay_date']; ?></td>
                                        <td><?= array_key_exists($row['employee'], $employees) ? $employees[$row['employee']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($row['total_earning']); ?></td>
                                        <td><?= round_decimels_digits($row['total_month_days']); ?></td>
                                        <td><?= round_decimels_digits($row['total_absents']); ?></td>
                                        <td><?= round_decimels_digits($row['total_deduction']); ?></td>
                                        <td><?= round_decimels_digits($row['net_salary']); ?></td>
                                        <td><?= $row['narration']; ?></td>
                                        <td>
                                            <?php if(check_user_access('confirm_payslips') === TRUE){ ?>
                                                <a href="<?= url('/payslips/confirm').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-info confirm-btn-trigger"><i class="fa fa-paper-plane">&nbsp; </i><?= print_lang($app_lang,'confirm'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_payslips') === TRUE){ ?>
                                                <a href="<?= url('/payslips/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_payslips') === TRUE){ ?>
                                                <a href="<?= url('/payslips/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>