<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mode_process'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mode_process_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_advance') === TRUE){ ?>
                <a href="<?php echo url('/process/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mode_process_view_add_btn'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_process_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_damage_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_carton_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_chigit_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_total_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_carton_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_process_view_thead_chigit_cost'); ?></th>
                                    <th class="text-center" style="min-width:150px; max-width:150px;"><?= print_lang($app_lang,'mode_process_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['cn_date'])[0]); ?></td>
                                        <td><?= $row['account_name'] ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= $row['qty_kg']; ?></td>
                                        <td><?= $row['damage']; ?></td>
                                        <td><?= $row['carton_qty']; ?></td>
                                        <td><?= $row['chigit_qty']; ?></td>
                                        <td><?= $row['total_cost']; ?></td>
                                        <td><?= $row['total_carton_cost']; ?></td>
                                        <td><?= $row['total_chigit_cost']; ?></td>
                                        <td>
                                            <?php if(check_user_access('add_process') === TRUE){ ?>
                                                <a href="<?= url('/process/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link">&nbsp; </i><?= print_lang($app_lang,'invoice'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_process') === TRUE){ ?>
                                                <a href="<?= url('/process/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_process') === TRUE){ ?>
                                                <a href="<?= url('/process/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>