<div id="confirm_msg_div" class="row wrapper border-bottom white-bg page-heading confirm-leave">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_production_add_view'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/production'); ?>"><?= print_lang($app_lang,'mod_production_add_view'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_production_edit_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>

        <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
            <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.$editing_data['serial_id']; ?>" readonly="">
        </div>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->

        <form id="production-form" action="<?= url('production/update').'/'.$editing_data['uid']; ?>">
            <input type="hidden" class="production-total-produced-qty" name="total_produced_qty" value="<?= $editing_data['total_produced_qty']; ?>">
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_add_input_currency'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required production-currency" name="currency">
                            <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_currency'); ?> --</option>
                            <?php foreach($currencies as $row){ ?>
                                <option <?php if($editing_data['currency'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_add_input_item'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required production-item" name="item">
                            <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_item'); ?> --</option>
                            <?php foreach($items as $row){ if(!in_array($row['uid'], $items_relation)){continue;} ?>
                                <option <?php if($editing_data['item'] == $row['uid']){echo "selected='selected'";}?> data-unit-name="<?= $row['purchase_unit_name']; ?>" value="<?= $row['uid']; ?>"><?= $row['name']; ?> (<?= $row['item_id']; ?>) (<?= $row['purchase_unit_name']; ?>)</option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_add_input_warehouse'); ?> <strong class="text-danger">*</strong></label>
                        <select class="form-control chosen-select cv-required production-warehouse" name="warehouse">
                            <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_warehouse'); ?> --</option>
                            <?php foreach($warehouses as $row){ if($row['type'] == 'raw'){continue;} ?>
                                <option <?php if($editing_data['warehouse'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_add_input_qty'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control cv-required production-qty" name="qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_qty'); ?>">
                    </div>
                </div>

                <div class="col-md-2 pointer-none">
                    <div class="form-group">
                        <label><?= print_lang($app_lang,'mod_production_add_input_cost'); ?> <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control cv-required production-item-cost" name="cost" value="<?= $editing_data['cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_cost'); ?>">
                    </div>
                </div>
            </div>

            <div class="production-relational-items-data">
                
                <?php
                    $items_produced_relation = std_obj_to_array(DB::table('production_details')->where('production_id',$editing_data['uid'])->where('pro_type','produced')->where('general','no')->get());
                ?>
                <h3><?= print_lang($app_lang,'mod_production_add_input_add_relational_produced_items'); ?></h3>
                <?php if(empty($items_produced_relation)){?>
                    <h6><?= print_lang($app_lang,'mod_production_add_input_add_relational_produced_items_not_found'); ?></h6>
                <?php } ?>
                <?php foreach($items_produced_relation as $row){
                    $item_data = fetch_table_where('items','uid',$row['item'],true);
                    $currency_data = fetch_table_where('currency','uid',$row['currency'],true);
                ?>
                    <div class="row produced-relational-items-row">
                        <div class="col-md-2 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control" name="produced_currency_name[]" value="<?= $currency_data['name']; ?>">
                                <input type="hidden" class="form-control" name="produced_currency[]" value="<?= $currency_data['uid']; ?>">
                            </div>
                        </div>
                        <div class="col-md-3 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control" name="produced_item_name[]" value="<?= $item_data['name']; ?>">
                                <input type="hidden" class="form-control" name="produced_item[]" value="<?= $row['item']; ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select cv-required" name="produced_warehouse[]">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_warehouse'); ?> --</option>
                                    <?php foreach($warehouses as $rrrow){ if($rrrow['type'] == 'raw'){continue;} ?>
                                        <option <?php if($row['warehouse'] == $rrrow['uid']){echo "selected='selected'";}?> value="<?= $rrrow['uid']; ?>"><?= $rrrow['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control produced-qty-input" name="produced_qty[]" value="<?= $row['qty']; ?>">
                                <input type="hidden" class="form-control produced-rel-qty-input" name="produced_rel_qty[]" value="<?= $row['rel_qty']; ?>">
                            </div>
                        </div>

                        <div class="col-md-2 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control produced-item-cost" name="produced_item_cost[]" value="<?= $row['rel_cost']; ?>">
                                <input type="hidden" class="form-control produced-item-cost-percentage" name="produced_item_cost_percentage[]" value="<?= $row['produced_item_cost_percentage']; ?>">
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <?php
                    $items_raw_relation = std_obj_to_array(DB::table('production_details')->where('production_id',$editing_data['uid'])->where('pro_type','raw')->where('general','no')->get());
                ?>
                <h3><?= print_lang($app_lang,'mod_production_add_input_add_relational_raw_items'); ?></h3>
                <?php foreach($items_raw_relation as $row){
                $item_data = fetch_table_where('items','uid',$row['item'],true);
                $currency_data = fetch_table_where('currency','uid',$row['currency'],true);

                $item_stats = json_decode($item_data['stats'],true);
                $item_warehouses = [];
                if(!empty($item_stats['avail_units']))
                {
                    foreach($item_stats['avail_units'] as $key => $iware)
                    {
                        $item_warehouses[] = $key;
                    }
                }

                ?>
                    <div class="row raw-relational-items-row">

                        <div class="col-md-2 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control" name="raw_currency_name[]" value="<?= $currency_data['name']; ?>">
                                <input type="hidden" class="form-control" name="raw_currency[]" value="<?= $currency_data['uid']; ?>">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <input type="text" class="form-control" name="raw_item_name[]" value="<?= $item_data['name']; ?>">
                                <input type="hidden" class="form-control" name="raw_item[]" value="<?= $row['item']; ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control chosen-select cv-required" name="raw_warehouse[]">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_warehouse'); ?> --</option>
                                    <?php foreach($warehouses as $irow){ if(!in_array($irow['uid'], $item_warehouses)){continue;} ?>
                                        <option <?php if($row['warehouse'] == $irow['uid']){echo "selected='selected'";}?> value="<?= $irow['uid']; ?>"><?= $irow['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control raw-qty-input" name="raw_qty[]" value="<?= $row['qty']; ?>">
                                <input type="hidden" class="form-control raw-rel-qty-input" name="raw_rel_qty[]" value="<?= $row['rel_qty']; ?>">
                            </div>
                        </div>

                        <div class="col-md-2 pointer-none">
                            <div class="form-group">
                                <input type="text" class="form-control raw-item-cost" name="raw_item_cost[]" value="<?= $row['rel_cost']; ?>">
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <hr>
                <div class="row">
                    <div class="col-md-2 pointer-none">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_production_add_input_total_system_expenses'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control production-total-system-expenses" name="total_system_expenses" value="<?= $editing_data['total_system_expenses']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_total_system_expenses'); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_production_add_input_total_expenses'); ?> </label>
                            <input type="text" class="form-control production-total-expenses" name="total_expenses" value="<?= $editing_data['total_expenses']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_total_expenses'); ?>">
                        </div>
                    </div>

                    <div class="col-md-2 pointer-none">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_production_add_input_total_raw_cost'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control production-total-raw-cost" name="total_raw_cost" value="<?= $editing_data['total_raw_cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_total_raw_cost'); ?>">
                        </div>
                    </div>

                    <div class="col-md-3 pointer-none">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_production_add_input_total_real_cost'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control production-total-real-cost" name="total_real_cost" value="<?= $editing_data['total_real_cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_total_real_cost'); ?>">
                        </div>
                    </div>

                    <div class="col-md-3 pointer-none">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'mod_production_add_input_produced_item_cost'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control production-per-item-produced-cost" name="produced_per_item_cost" value="<?= $editing_data['produced_per_item_cost']; ?>" placeholder="<?= print_lang($app_lang,'mod_production_add_input_produced_item_cost'); ?>">
                        </div>
                    </div>
                </div>

            </div>

            <div class="row extra-mar-botm">
                <div class="col-md-12 text-right">
                    <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/production'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                    <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                </div>
            </div>
        </form>

    </div>

</div>