<h3><?= print_lang($app_lang,'mod_production_raw_add_input_add_relational_raw_items'); ?></h3>


<?php if(empty($items_raw_relation)){?>
	<h6><?= print_lang($app_lang,'mod_production_raw_add_input_add_relational_raw_items_not_fout'); ?></h6>
<?php } ?>


<?php foreach($items_raw_relation as $row){
$item_data = fetch_table_where('items','uid',$row['item'],true);

$item_avg_cost = $item_data['_avg_cost'];
$item_currency = $item_data['currency'];
$item_currency_equalance = $item_data['currency_usd_equalance'];
if($item_currency != $production_currency['uid'])
{
	$item_avg_cost = amount_conversion($item_avg_cost, $item_currency_equalance, $production_currency['usd_equalance']);
}

$item_stats = json_decode($item_data['stats'],true);
$item_warehouses = [];
if(!empty($item_stats['avail_units']))
{
	foreach($item_stats['avail_units'] as $key => $iware)
	{
		$item_warehouses[] = $key;
	}
}

?>
	<div class="row raw-raw-relational-items-row">
		<div class="col-md-2 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control" name="raw_currency_name[]" value="<?= $production_currency['name']; ?>">
			    <input type="hidden" class="form-control" name="raw_currency[]" value="<?= $production_currency['uid']; ?>">
			</div>
		</div>
		<div class="col-md-3 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control" name="raw_item_name[]" value="<?= $row['item_name']; ?>">
			    <input type="hidden" class="form-control" name="raw_item[]" value="<?= $row['item']; ?>">
			</div>
		</div>

		<div class="col-md-3">
		    <div class="form-group">
		        <select class="form-control chosen-select cv-required" name="raw_warehouse[]">
		            <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_warehouse'); ?> --</option>
		            <?php foreach($warehouses as $irow){ if(!in_array($irow['uid'], $item_warehouses)){continue;} ?>
		                <option value="<?= $irow['uid']; ?>"><?= $irow['name']; ?></option>
		            <?php } ?>
		        </select>
		    </div>
		</div>

		<div class="col-md-2 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control raw-qty-input" name="raw_qty[]" value="<?= $row['qty']; ?>">
			    <input type="hidden" class="form-control raw-rel-qty-input" name="raw_rel_qty[]" value="<?= $row['qty']; ?>">
			</div>
		</div>

		<div class="col-md-2 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control raw-item-cost" name="raw_item_cost[]" value="<?= $item_avg_cost; ?>">
			</div>
		</div>
	</div>
<?php } ?>


<h3><?= print_lang($app_lang,'mod_production_raw_add_input_add_relational_produced_items'); ?></h3>
<?php foreach($items_produced_relation as $row){
	$item_data = fetch_table_where('items','uid',$row['item'],true);
?>
	<div class="row produced-raw-relational-items-row">

		<div class="col-md-2 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control" name="raw_currency_name[]" value="<?= $production_currency['name']; ?>">
			    <input type="hidden" class="form-control" name="raw_currency[]" value="<?= $production_currency['uid']; ?>">
			</div>
		</div>

		<div class="col-md-3 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control" name="produced_item_name[]" value="<?= $row['item_name']; ?>">
			    <input type="hidden" class="form-control" name="produced_item[]" value="<?= $row['item']; ?>">
			</div>
		</div>

		<div class="col-md-3">
		    <div class="form-group">
		        <select class="form-control chosen-select cv-required" name="produced_warehouse[]">
		            <option disabled="" value="" selected="">-- <?= print_lang($app_lang,'mod_production_add_input_warehouse'); ?> --</option>
		            <?php foreach($warehouses as $rrrow){ if($rrrow['type'] == 'raw'){continue;} ?>
		                <option value="<?= $rrrow['uid']; ?>"><?= $rrrow['name']; ?></option>
		            <?php } ?>
		        </select>
		    </div>
		</div>

		<div class="col-md-2 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control produced-qty-input" name="produced_qty[]" value="<?= $row['qty']; ?>">
			    <input type="hidden" class="form-control produced-rel-qty-input" name="produced_rel_qty[]" value="<?= $row['qty']; ?>">
			</div>
		</div>

		<div class="col-md-2 pointer-none">
			<div class="form-group">
			    <input type="text" class="form-control produced-item-cost" name="produced_item_cost[]">
			    <input type="hidden" class="form-control produced-item-cost-percentage" name="produced_item_cost_percentage[]" value="<?= $row['cost_percentage']; ?>">
			</div>
		</div>
	</div>
<?php } ?>

<hr>
<?php 
	
	$expenses_all_in_main_currency = [];
	foreach($currencies as $currency)
	{
	    $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray());
	    $expenses = DB::table('expenses')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first();
	    $expenses_balance = $expenses->balance;
	    $expenses_all_in_main_currency[] = amount_conversion($expenses_balance, (float)$currency['usd_equalance'], $production_currency['usd_equalance']);
	}
?>

<div class="row">
	<div class="col-md-2 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_raw_add_input_total_system_expenses'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control" name="total_system_expenses" value="<?= round_decimels_digits_3(array_sum($expenses_all_in_main_currency)); ?>" placeholder="<?= print_lang($app_lang,'mod_production_raw_add_input_total_system_expenses'); ?>">
		</div>
	</div>
	<div class="col-md-2">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_raw_add_input_total_expenses'); ?></label>
		    <input type="text" class="form-control raw-production-total-expenses" name="total_expenses" value="" placeholder="<?= print_lang($app_lang,'mod_production_raw_add_input_total_expenses'); ?>">
		</div>
	</div>

	<div class="col-md-2 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_raw_add_input_total_raw_cost'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control production-total-raw-cost" name="total_raw_cost" placeholder="<?= print_lang($app_lang,'mod_production_raw_add_input_total_raw_cost'); ?>">
		</div>
	</div>

	<div class="col-md-3 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_raw_add_input_total_real_cost'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control production-total-real-cost" name="total_real_cost" placeholder="<?= print_lang($app_lang,'mod_production_raw_add_input_total_real_cost'); ?>">
		</div>
	</div>

	<div class="col-md-3 pointer-none">
		<div class="form-group">
		    <label><?= print_lang($app_lang,'mod_production_raw_add_input_produced_item_cost'); ?> <strong class="text-danger">*</strong></label>
		    <input type="text" class="form-control production-per-item-produced-cost" name="produced_per_item_cost" placeholder="<?= print_lang($app_lang,'mod_production_raw_add_input_produced_item_cost'); ?>">
		</div>
	</div>
</div>