<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_project'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/projects'); ?>"><?= print_lang($app_lang,'projects'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_project'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="project-edit-form" action="<?php echo url('/projects/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="name" value="<?= $editing_data['name']; ?>" placeholder="<?= print_lang($app_lang,'project_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_address'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="address" value="<?= $editing_data['address']; ?>" placeholder="<?= print_lang($app_lang,'project_address'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'contact_person'); ?></label>
                                <input type="text" class="form-control" name="contact_person" value="<?= $editing_data['contact_person']; ?>" placeholder="<?= print_lang($app_lang,'contact_person'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'contact_number'); ?></label>
                                <input type="text" class="form-control" name="contact_number" value="<?= $editing_data['contact_number']; ?>" placeholder="<?= print_lang($app_lang,'contact_number'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'company_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="company" value="<?= $editing_data['company']; ?>" placeholder="<?= print_lang($app_lang,'company_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="client">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?> data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_cost'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="cost" value="<?= $editing_data['cost']; ?>" placeholder="<?= print_lang($app_lang,'project_cost'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'cash_paid_account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="cash_paid_account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'cashbook' OR $row['type'] == 'bank'){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($editing_data['cash_paid_account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'cash_paid'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="cash_paid" value="<?= $editing_data['cash_paid']; ?>" placeholder="<?= print_lang($app_lang,'cash_paid'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'pending_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="pending_amount" value="<?= $editing_data['pending_amount']; ?>" placeholder="<?= print_lang($app_lang,'pending_amount'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'start_date'); ?> <strong class="text-danger">*</strong></label>
                                <?php $start_date = display_true_date($editing_data['start_date']); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="start_date" value="<?= true_date_for_inputs($start_date); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="start_date" value="<?= true_date_for_inputs($start_date); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'end_date'); ?> <strong class="text-danger">*</strong></label>
                                <?php $end_date = display_true_date($editing_data['end_date']); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="end_date" value="<?= true_date_for_inputs($end_date); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="end_date" value="<?= true_date_for_inputs($end_date); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="comments" value="<?= $editing_data['comments']; ?>" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'image'); ?></label>
                                <input type="file" class="form-control" name="image">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'login_name'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="username" value="<?= $editing_data['username']; ?>" placeholder="<?= print_lang($app_lang,'login_name'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'password'); ?></label>
                                <input type="password" class="form-control" name="password" placeholder="<?= print_lang($app_lang,'password'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'confirm_password'); ?></label>
                                <input type="password" class="form-control" name="confirm_password" placeholder="<?= print_lang($app_lang,'confirm_password'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/projects'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>