<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'process_details'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/projects/in-process'); ?>"><?= print_lang($app_lang,'in_process_projects'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'process_details'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'process_details_listing'); ?></h2>
                    
                    <form id="process-details-search-form" action="<?= url('/projects/process-details').'/'.$project_uid; ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="item">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'item'); ?> --</option>
                                                    <?php foreach($items as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="supervisor">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'supervisor'); ?> --</option>
                                                    <?php foreach($users as $row){ ?>
                                                        <option value="<?= $row['uid']; ?>" <?php if($search_supervisor == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <select class="form-control chosen-select" name="type">
                                                    <option value="" selected="">-- <?= print_lang($app_lang,'type'); ?> --</option>
                                                    <option value="cash_expenses" <?php if($search_type == 'cash_expenses'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cash_expenses'); ?></option>
                                                    <option value="inventory_expenses" <?php if($search_type == 'inventory_expenses'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'inventory_expenses'); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th style="min-width: 100px;" class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'description'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'supervisor'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'report'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_qty = array();
                                $total_debit = array();
                                $total_credit = array();

                                foreach($page_data as $row){
                                    
                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                    $unit = NULL;
                                    if($row['entry_type'] == 'expenses_inventory_deduction')
                                    {
                                        // get unit name
                                        $item_uid = $row['source_data']['item'];
                                        $item_data = array_key_exists($item_uid,$items) ? $items[$item_uid] : array();
                                        if(isset($item_data['uid']))
                                        {
                                            if($row['unit'] == 'purchase'){ $unit = $item_data['purchase_unit']; }
                                            if($row['unit'] == 'sale'){ $unit = $item_data['sale_unit']; }
                                            if($row['unit'] == 'production'){ $unit = $item_data['production_unit']; }
                                            $unit = array_key_exists($unit,$units) ? $units[$unit]['short'] : NULL;
                                        }
                                    }
                                    if($row['entry_type'] == 'material')
                                    {
                                        $unit = $row['unit'];
                                    }
                                    $supervisor = array_key_exists($row['supervisor'],$users) ? $users[$row['supervisor']]['name'] : NULL;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(date("Y-m-d",strtotime($row['date']))); ?></td>
                                        <td><?= $row['description']; ?></td>
                                        <td><?= $supervisor; ?></td>
                                        <td><?= $row['type']; ?></td>
                                        <td><?= $unit; ?></td>
                                        <td><?= amount_number_format( $row['qty'] ); ?><?php $total_qty[] = (float)$row['qty']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($row['debit']); ?><?php $total_debit[] = (float)$row['debit']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($row['credit']); ?><?php $total_credit[] = (float)$row['credit']; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_batch') === TRUE){ ?>
                                                <a href="<?= url('/projects-reports').'?project='.$project_uid; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-chart">&nbsp; </i><?= print_lang($app_lang,'report'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_qty) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_debit) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_credit) ); ?></td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>