<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'in_process_projects'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'in_process_projects'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'in_process_projects_listing'); ?></h2>
                    
                    <form id="projects-search-form" action="<?= url('/projects/in-process'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="client">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'client'); ?> --</option>
                                                <?php foreach($clients as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'contact_number'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'end_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cash_paid'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'pending_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_deductions'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'process_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'document'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_cost = array();
                                $total_cash_paid = array();
                                $total_pending_amount = array();

                                foreach($pageData as $row){
                                    
                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;

                                    $project_deductions = calculate_project_deductions($row['uid']);
                                    // $deductions_balance = (float)$project_deductions['expenses'] - (float)$project_deductions['payments'];
                                    $deductions_balance = (float)$project_deductions['expenses'];
                                    $profit_amount = (float)$row['cost'] - $deductions_balance;

                                    $image_path = '/uploads/projects/'.$row['image'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }

                                    // project amount calculations
                                    $cost = (float)$row['cost'];
                                    $payment_deductions = DB::table('payment_deductions')->where('project',$row['uid'])->sum('project_according_amount');
                                    $cash_paid = (float)$row['cash_paid'] + $payment_deductions;
                                    $pending_amount = $cost - $cash_paid;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><?= $row['contact_number']; ?></td>
                                        <td><?= array_key_exists($row['client'],$clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                        <td><?= $row['end_date']; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($cost); ?><?php $total_cost[] = $cost; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($cash_paid); ?><?php $total_cash_paid[] = $cash_paid; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($pending_amount); ?><?php $total_pending_amount[] = $pending_amount; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($deductions_balance); ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($profit_amount); ?></td>
                                        <td>
                                            <?php if(check_user_access('project_inprocess_projects_process_details') === TRUE){ ?>
                                                <a href="<?= url('/projects/process-details').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-spinner">&nbsp; </i><?= print_lang($app_lang,'process'); ?></a>
                                            <?php } ?>
                                        </td>
                                        <td><?= $image_html; ?></td>
                                        <td>
                                            <?php if(check_user_access('project_inprocess_projects_complete') === TRUE){ ?>
                                                <a href="<?= url('/projects/complete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary confirm-btn-trigger"><i class="fa fa-check">&nbsp; </i><?= print_lang($app_lang,'complete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_cost) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_cash_paid) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_pending_amount) ); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>