<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_expense_deduction'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/expenses-deductions'); ?>"><?= print_lang($app_lang,'expenses_deductions'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'add_expense_deduction'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">

                <form role="form" id="project-expenses-deductions-form" class="new-form" action="<?php echo url('/project-expenses-deductions/save'); ?>">
                <input type="hidden" name="project_received_money" value="<?= $project_received_money_balance; ?>">
                <input type="hidden" name="project" value="<?= $project['uid']; ?>">
                <input type="hidden" name="project_currency" value="<?= $project['currency']; ?>">
                <input type="hidden" name="project_currency_usd_equalance" value="<?= (float)$project['currency_usd_equalance']; ?>">

                    <!-- cash expenses fields -->
                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'deduction_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="deduction_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="project"><?= print_lang($app_lang,'project'); ?></option>
                                    <option value="private"><?= print_lang($app_lang,'private'); ?></option>
                                    <option value="other"><?= print_lang($app_lang,'other'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="amount" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <input type="date" class="form-control" name="cash_date">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm cash-expenses-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'scan_copy'); ?></label>
                                <input type="file" class="form-control" name="scan_copy">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'payment_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="payment_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="cash"><?= print_lang($app_lang,'cash'); ?></option>
                                    <option value="loan"><?= print_lang($app_lang,'loan'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_currency_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="project_according_amount" placeholder="<?= print_lang($app_lang,'project_currency_amount'); ?>">
                            </div>
                        </div>
                    </div>
                    <!-- cash expenses fields -->

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <textarea rows="4" class="form-control" name="comments" placeholder="<?= print_lang($app_lang,'comments'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/project-expenses-deductions'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

            </form>
            </div>
        </div>
    </div>

</div>