<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'received_money'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'received_money'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'received_money_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'balance'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $credits = array();
                                $debits = array();

                                foreach($pageData as $row){
                                    $row_currency = array_key_exists($project_data['currency'],$currencies) ? $currencies[$project_data['currency']]['symbol'] : NULL;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['date']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td><?= $row_currency; ?><span><?= amount_number_format((float)$row['credit']); ?></span><?php $credits[] = (float)$row['credit']; ?></td>
                                        <td><?= $row_currency; ?><span><?= amount_number_format((float)$row['debit']); ?></span><?php $debits[] = (float)$row['debit']; ?></td>
                                        <td><?= $row_currency; ?><span><?= amount_number_format( array_sum($credits) - array_sum($debits) ); ?></span></td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= date('Y-m-d'); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= isset($row_currency) ? $row_currency : NULL; ?><span><?= amount_number_format( array_sum($credits) ); ?></span></td>
                                    <td><?= isset($row_currency) ? $row_currency : NULL; ?><span><?= amount_number_format( array_sum($debits) ); ?></span></td>
                                    <td><?= isset($row_currency) ? $row_currency : NULL; ?><span><?= amount_number_format( array_sum($credits) - array_sum($debits) ); ?></span></td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal inmodal" id="project-loans-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="project-loans-form" action="">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'loan_modal_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'loan_modal_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">

                <div class="row extra-mar-botm">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'loan_amount'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control pointer-none" name="loan_amount" placeholder="<?= print_lang($app_lang,'loan_amount'); ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'cash_paid'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="cash_paid" placeholder="<?= print_lang($app_lang,'cash_paid'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'pending_amount'); ?></label>
                            <input type="text" class="form-control pointer-none" name="pending_amount" placeholder="<?= print_lang($app_lang,'pending_amount'); ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'receipt'); ?></label>
                            <input type="file" class="form-control" name="receipt">
                        </div>
                    </div>
                </div>

                <div class="row extra-mar-botm">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'details'); ?></label>
                            <textarea class="form-control" name="details" placeholder="<?= print_lang($app_lang,'details'); ?>"></textarea>
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'update'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>