<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'loans'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'loans'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'loans_listing'); ?></h2>
                    
                    <form id="project-loans-search-form" action="<?= url('/project-loans'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cash_paid'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'pending_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipt'); ?></th>
                                    <th class="text-center" style="min-width:100px; max-width:100px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_amount = array();
                                $total_cash_paid = array();
                                $total_pending_amount = array();

                                foreach($pageData as $row){
                                    
                                    if($row['user_type'] == 'project_user')
                                    {
                                        if($row['payment_type'] == 'cash'){ continue; }
                                    }

                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;

                                    $loan_amount = (float)$row['amount'];
                                    $loan_cash_paid = (float)$row['loan_cash_paid'];
                                    $loan_pending_amount = $loan_amount - $loan_cash_paid;

                                    $image_path = '/uploads/project-loans/'.$row['loan_receipt'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }
                                ?>
                                    <tr class="text-center loan-row-<?= $row['uid']; ?>">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['edate']; ?></td>
                                        <td><?= array_key_exists($row['account'],$accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td class="loan-amount-row" data-loan-amount="<?= $loan_amount; ?>"><?= $row_currency; ?><span><?= amount_number_format($loan_amount); ?></span><?php $total_amount[] = $loan_amount; ?></td>
                                        <td class="loan-cash-paid-row"><?= $row_currency; ?><span><?= amount_number_format($loan_cash_paid); ?></span><?php $total_cash_paid[] = $loan_cash_paid; ?></td>
                                        <td class="loan-pending-amount-row"><?= $row_currency; ?><span><?= amount_number_format($loan_pending_amount); ?></span><?php $total_pending_amount[] = $loan_pending_amount; ?></td>
                                        <td class="loan-details-row"><span><?= $row['loan_details']; ?></span></td>
                                        <td class="loan-receipt-row"><?= $image_html; ?></td>
                                        <td>
                                            <a href="javascript:void(0);" data-url="<?= url('/project-loans/update').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary loan-paid-trigger"><i class="fa fa-openid">&nbsp;&nbsp; </i><?= print_lang($app_lang,'paid'); ?></a>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_amount) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_cash_paid) ); ?></td>
                                    <td><?= amount_number_format( array_sum($total_pending_amount) ); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal inmodal" id="project-loans-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated flipInX">
            <form id="project-loans-form" action="">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title"><?= print_lang($app_lang,'loan_modal_title'); ?></h4>
                <small class="font-bold"><?= print_lang($app_lang,'loan_modal_tag_line'); ?></small>
            </div>
            <div class="modal-body bg-white">

                <div class="row extra-mar-botm">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'loan_amount'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control pointer-none" name="loan_amount" placeholder="<?= print_lang($app_lang,'loan_amount'); ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'cash_paid'); ?> <strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="cash_paid" placeholder="<?= print_lang($app_lang,'cash_paid'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'pending_amount'); ?></label>
                            <input type="text" class="form-control pointer-none" name="pending_amount" placeholder="<?= print_lang($app_lang,'pending_amount'); ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'receipt'); ?></label>
                            <input type="file" class="form-control" name="receipt">
                        </div>
                    </div>
                </div>

                <div class="row extra-mar-botm">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?= print_lang($app_lang,'details'); ?></label>
                            <textarea class="form-control" name="details" placeholder="<?= print_lang($app_lang,'details'); ?>"></textarea>
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'cancel'); ?></button>
                <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'update'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>