<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_project_payment'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/project-payments'); ?>"><?= print_lang($app_lang,'project_payments'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_project_payment'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="project-payments-form" action="<?php echo url('/project-payments/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'amount'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="amount" value="<?= $editing_data['amount']; ?>" placeholder="<?= print_lang($app_lang,'amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'date'); ?> <strong class="text-danger">*</strong></label>
                                <?php $pdate = display_true_date($editing_data['pdate']); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="pdate" value="<?= true_date_for_inputs($pdate); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="pdate" value="<?= true_date_for_inputs($pdate); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'scan_copy'); ?></label>
                                <input type="file" class="form-control" name="scan_copy">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-currency="<?= $row['currency']; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" <?php if($editing_data['project'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project_currency_amount'); ?></label>
                                <input type="text" class="form-control pointer-none" name="project_according_amount" value="<?= $editing_data['project_according_amount']; ?>" placeholder="<?= print_lang($app_lang,'project_currency_amount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="account">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($accounts as $row){ ?>
                                        <?php if($row['type'] == 'cashbook' OR $row['type'] == 'bank' OR $row['type'] == 'partnership_account' OR $row['type'] == 'personal_account'){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($editing_data['account'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'payment_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="payment_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="project" <?php if($editing_data['payment_type'] == 'project'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'project'); ?></option>
                                    <option value="private" <?php if($editing_data['payment_type'] == 'private'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'private'); ?></option>
                                    <option value="other" <?php if($editing_data['payment_type'] == 'other'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'other'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'user'); ?></label>
                                <select class="form-control chosen-select" name="user">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_user'); ?> --</option>
                                    <?php foreach($users as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['user'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="comments" value="<?= $editing_data['comments']; ?>" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/project-payments'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>