<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'project_payments'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'project_payments'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_project_projects_payments') === TRUE){ ?>
                <a href="<?php echo url('/project-payments/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_project_payment'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'project_payments_listing'); ?></h2>
                    
                    <form id="project-payments-search-form" action="<?= url('/project-payments'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="project">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'project'); ?> --</option>
                                            <?php foreach($projects as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_project == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'payment_type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'user'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'comments'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipt'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                $total_amount = array();
                                $total_cash_paid = array();
                                $total_pending_amount = array();

                                foreach($pageData as $row){
                                    
                                    $row_currency = array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                    $image_path = '/uploads/project-payments/'.$row['scan_copy'];
                                    if(is_file(base_path().$image_path))
                                    {
                                        $image_html = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').$image_path.'">'.print_lang($app_lang,'preview').'</a>'; // data-gallery=""
                                    }
                                    else
                                    {
                                        $image_html = '<span class="label label-info">'.print_lang($app_lang,'no_image').'</span>';
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['pdate']); ?></td>
                                        <td><?= print_lang($app_lang,$row['payment_type']); ?></td>
                                        <td><?= array_key_exists($row['user'],$users) ? $users[$row['user']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($row['project'],$projects) ? $projects[$row['project']]['name'] : NULL; ?></td>
                                        <td><?= $row_currency; ?><?= amount_number_format($row['amount']); ?><?php $total_amount[] = (float)$row['amount']; ?></td>
                                        <td><?= array_key_exists($row['account'],$accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td><?= $row['comments']; ?></td>
                                        <td><?= $image_html; ?></td>
                                        <td>
                                            <?php if(check_user_access('edit_project_projects_payments') === TRUE){ ?>
                                                <a href="<?= url('/project-payments/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_project_projects_payments') === TRUE){ ?>
                                                <a href="<?= url('/project-payments/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td><?= amount_number_format( array_sum($total_amount) ); ?></td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>