<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_project_assigning'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/projects-assign'); ?>"><?= print_lang($app_lang,'projects_assigning'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_project_assigning'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="projects-assign-form" action="<?php echo url('/projects-assign/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'assign_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="assign_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="employee"><?= print_lang($app_lang,'employee'); ?></option>
                                    <option value="machinery"><?= print_lang($app_lang,'machinery'); ?></option>
                                    <option value="material"><?= print_lang($app_lang,'material'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm for-employee display-none">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="employee">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_employee'); ?> --</option>
                                    <?php foreach($employees as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-duration-type="<?= $row['duration_type']; ?>"><?= array_key_exists($row['employee'],$accounts) ? $accounts[$row['employee']]['name'] : NULL; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group duration-labels">
                                <label class="employee-monthly-t-label display-none"><?= print_lang($app_lang,'number_of_months'); ?> <strong class="text-danger">*</strong></label>
                                <label class="employee-days-t-label"><?= print_lang($app_lang,'number_of_days'); ?> <strong class="text-danger">*</strong></label>
                                <label class="employee-hours-t-label display-none"><?= print_lang($app_lang,'number_of_hours'); ?> <strong class="text-danger">*</strong></label>
                                <label class="employee-sqm-t-label display-none"><?= print_lang($app_lang,'number_of_sqms'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="num_of_duration" placeholder="<?= print_lang($app_lang,'number'); ?>">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="employee_comments" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm for-machinery display-none">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'machinery'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="machinery">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_machinery'); ?> --</option>
                                    <?php foreach($machinery as $row){ ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['machinery_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'number_of_hours'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="number_of_hours" placeholder="<?= print_lang($app_lang,'number_of_hours'); ?>">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="machinery_comments" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm for-material display-none">
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="warehouse">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                            <?php foreach($warehouses as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="item">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                            
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="material_comments" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/projects-assign'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>