<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_project_assigning'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/projects-assign'); ?>"><?= print_lang($app_lang,'projects_assigning'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_project_assigning'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="projects-assign-form" action="<?php echo url('/projects-assign/update').'/'.$editing_data['uid']; ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'project'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="project">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_project'); ?> --</option>
                                    <?php foreach($projects as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['project'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'assign_type'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="assign_type">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                    <option value="employee" <?php if($editing_data['assign_type'] == 'employee'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'employee'); ?></option>
                                    <option value="machinery" <?php if($editing_data['assign_type'] == 'machinery'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'machinery'); ?></option>
                                    <option value="material" <?php if($editing_data['assign_type'] == 'material'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'material'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm for-employee <?php if($editing_data['assign_type'] != 'employee'){ echo 'display-none'; } ?>">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'employee'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="employee">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_employee'); ?> --</option>
                                    <?php $employee_duration_type = 'days'; foreach($employees as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" data-duration-type="<?= $row['duration_type']; ?>" <?php if($editing_data['employee'] == $row['uid']){ echo 'selected="selected"'; $employee_duration_type = $row['duration_type']; } ?>><?= array_key_exists($row['employee'],$accounts) ? $accounts[$row['employee']]['name'] : NULL; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group duration-labels">
                                <label class="employee-monthly-t-label <?php if($employee_duration_type != 'monthly'){ echo 'display-none'; } ?>"><?= print_lang($app_lang,'number_of_months'); ?> <strong class="text-danger">*</strong></label>
                                <label class="employee-days-t-label <?php if($employee_duration_type != 'days'){ echo 'display-none'; } ?>"><?= print_lang($app_lang,'number_of_days'); ?> <strong class="text-danger">*</strong></label>
                                <label class="employee-hours-t-label <?php if($employee_duration_type != 'hours'){ echo 'display-none'; } ?>"><?= print_lang($app_lang,'number_of_hours'); ?> <strong class="text-danger">*</strong></label>
                                <label class="employee-sqm-t-label <?php if($employee_duration_type != 'sqm'){ echo 'display-none'; } ?>"><?= print_lang($app_lang,'number_of_sqms'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="num_of_duration" value="<?= $editing_data['num_of_duration']; ?>" placeholder="<?= print_lang($app_lang,'number'); ?>">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="employee_comments" value="<?= $editing_data['employee_comments']; ?>" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm for-machinery <?php if($editing_data['assign_type'] != 'machinery'){ echo 'display-none'; } ?>">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'machinery'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="machinery">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_machinery'); ?> --</option>
                                    <?php foreach($machinery as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($editing_data['machinery'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['machinery_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'number_of_hours'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="number_of_hours" value="<?= $editing_data['number_of_hours']; ?>" placeholder="<?= print_lang($app_lang,'number_of_hours'); ?>">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="machinery_comments" value="<?= $editing_data['machinery_comments']; ?>" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm for-material <?php if($editing_data['assign_type'] != 'material'){ echo 'display-none'; } ?>">
                        <div class="col-md-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="warehouse">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                            <?php foreach($warehouses as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['warehouse'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="item">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                            <?php foreach($items as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['item'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'comments'); ?></label>
                                <input type="text" class="form-control" name="material_comments" value="<?= $editing_data['material_comments']; ?>" placeholder="<?= print_lang($app_lang,'comments'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/projects-assign'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>