<style type="text/css">
    .custom-col{padding: 2px !important;}
</style>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'project_assigning_report_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'project_assigning_report_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
       
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'project_assigning_report_title_listing'); ?></h2>
                    
                    <form id="projects-assign-report-search-form" action="<?= url('/projects/project-assign-report'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-2 custom-col">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="project">
                                            <option value="">-- <?= print_lang($app_lang,'project_assigning_report_filter_project'); ?> --</option>
                                            <?php foreach($projects as $row){ ?>
                                                <option <?php if($search_project == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2 custom-col">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="employee">
                                            <option value="">-- <?= print_lang($app_lang,'project_assigning_report_filter_employee'); ?> --</option>
                                            <?php foreach($employees as $row){ ?>
                                                <option <?php if($search_employee == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2 custom-col">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="machinery">
                                            <option value="">-- <?= print_lang($app_lang,'project_assigning_report_filter_material'); ?> --</option>
                                            <?php foreach($machinery as $row){ ?>
                                                <option <?php if($search_machinery == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['machinery_name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2 custom-col">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="item">
                                            <option value="">-- <?= print_lang($app_lang,'project_assigning_report_filter_machinery'); ?> --</option>
                                            <?php foreach($items as $row){ ?>
                                                <option <?php if($search_item == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2 custom-col">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'project_assigning_report_filter_from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2 custom-col">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'project_assigning_report_filter_to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'project_assigning_report_filter_search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px;"><?= print_lang($app_lang,'project_assigning_report_thead_serial'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_project'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_type'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_work_time'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_employee'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_machinery'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_material'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_report_thead_comments'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $i = 1;
                                $qty_total = array();
                                $comments = '';
                                foreach($pageData as $data){
                                    $row = get_project_assign_ledger($data);
                                    if($data['assign_type'] == 'employee')
                                    {
                                        $comments = $data['employee_comments'];
                                        // get employee details from contracts table | employee = contract_id
                                        $employee_contract_details = fetch_table_where('ccontracts','uid',$data['employee'],true);
                                        $employee_duraction_type = print_lang($app_lang,(isset($employee_contract_details['duration_type'])) ? $employee_contract_details['duration_type'] : NULL);
                                        $row_working_time = amount_number_format($row['working_time']).' '.$employee_duraction_type;
                                    }
                                    if($data['assign_type'] == 'machinery')
                                    {
                                        $comments = $data['machinery_comments'];
                                        $row_working_time = amount_number_format($row['working_time']).' Hours';
                                    }
                                    if($data['assign_type'] == 'material')
                                    {
                                        $comments = $data['material_comments'];
                                        $row_working_time = amount_number_format($row['working_time']);
                                    }

                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(date("Y-m-d",strtotime($data['created_at']))); ?></td>
                                        <td><?= array_key_exists($data['project'],$projects) ? $projects[$data['project']]['name'] : NULL; ?></td>
                                        <td><?= print_lang($app_lang,$data['assign_type']); ?></td>
                                        <td>
                                            <?= $row_working_time; ?>
                                        </td>
                                        <td><?= array_key_exists($row['account'],$accounts) ? $accounts[$row['account']]['name'] : NULL; ?></td>
                                        <td><?= array_key_exists($data['machinery'],$machinery) ? $machinery[$data['machinery']]['machinery_name'] : NULL; ?></td>
                                        <td><?= array_key_exists($data['item'],$items) ? $items[$data['item']]['name'] : NULL; ?></td>
                                        <td><?= (float)$row['qty']; $qty_total[] = (float)$row['qty']; ?></td>
                                        <td><?= $comments; ?></td>
                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date("Y-m-d")); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= array_sum($qty_total); ?></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>