<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'projects_assigning'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'projects_assigning'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_project_assigning') === TRUE){ ?>
                <a href="<?php echo url('/projects-assign/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_project_assigning'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'projects_assigning_listing'); ?></h2>
                    
                    <form id="projects-assign-search-form" action="<?= url('/projects-assign'); ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="type">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_type'); ?> --</option>
                                            <option value="employee" <?php if($search_type == 'employee'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'employee'); ?></option>
                                            <option value="machinery" <?php if($search_type == 'machinery'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'machinery'); ?></option>
                                            <option value="material" <?php if($search_type == 'material'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'material'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/projects-assign/print').'?'.'type='.$search_type.'&from='.true_date_for_inputs($search_from).'&to='.true_date_for_inputs($search_to); ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'project'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'type'); ?></th>

                                    <th class="text-center"><?= print_lang($app_lang,'name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'comments'); ?></th>
                                    

                                    <th class="text-center"><?= print_lang($app_lang,'project_assigning_status'); ?></th>
                                    <th class="text-center" style="min-width:150px; width:150px; max-width:150px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['created_at']); ?></td>
                                        <td><?= array_key_exists($row['project'],$projects) ? $projects[$row['project']]['name'] : NULL; ?></td>
                                        <td><?= print_lang($app_lang,$row['assign_type']); ?></td>

                                        <?php
                                            $name = NULL;
                                            $comments = NULL;
                                            if($row['assign_type'] == 'employee')
                                            {
                                                $employee_uid = array_key_exists($row['employee'],$ccontracts) ? $ccontracts[$row['employee']]['employee'] : NULL;
                                                $employee_duration_type = array_key_exists($row['employee'],$ccontracts) ? $ccontracts[$row['employee']]['duration_type'] : NULL;
                                                $employee_duration_type = print_lang($app_lang,$employee_duration_type);
                                                $name = array_key_exists($employee_uid,$employees) ? $employees[$employee_uid]['name'] : NULL;
                                                $name = $name.'('.$employee_duration_type.')';
                                                $comments = $row['employee_comments'];
                                            }

                                            if($row['assign_type'] == 'machinery')
                                            {
                                                $name = array_key_exists($row['machinery'],$ccontracts) ? $ccontracts[$row['machinery']]['machinery_name'] : NULL;
                                                $comments = $row['machinery_comments'];
                                            }
                                            
                                            if($row['assign_type'] == 'material')
                                            {
                                                $name = array_key_exists($row['item'],$items) ? $items[$row['item']]['name'] : NULL;
                                                $comments = $row['material_comments'];
                                            }
                                        ?>
                                        <td><?= $name; ?></td>
                                        <td><?= $comments; ?></td>

                                        <?php
                                            if($row['user_request'] == 'yes')
                                            {
                                                if($row['status'] == 'pending')
                                                {
                                                    $status = 'pending';
                                                }
                                                else
                                                {
                                                    $status = 'passed';
                                                }
                                            }
                                            else
                                            {
                                                $status = 'passed';
                                            }
                                        ?>
                                        <td>
                                            <?php if($status == 'pending'){?>
                                                <a href="<?= url('/projects-assign/status').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-default url-elem"><i class="fa fa-times"></i>&nbsp; <?= print_lang($app_lang,'project_assigning_pending'); ?></a>
                                            <?php }else{?>
                                                <span class="label label-success"><?= print_lang($app_lang,'project_assigning_passed'); ?></span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if(check_user_access('edit_project_assigning') === TRUE){ ?>
                                                <a href="<?= url('/projects-assign/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i>&nbsp; <?= print_lang($app_lang,'edit'); ?></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_project_assigning') === TRUE){ ?>
                                                <a href="<?= url('/projects-assign/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>