<?php $item_settings = get_item_settings(); ?>
<style type="text/css">
    .chosen-container a.chosen-single{line-height: 24px !important;}
</style>
<div id="confirm_msg_div" class="row wrapper border-bottom white-bg page-heading confirm-leave">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_new_purchase'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/purchases'); ?>"><?= print_lang($app_lang,'purchases'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_purchase'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>

<?php
$item_settings = get_item_settings();
if($item_settings['item_measurements'] == 'get')
{
    $unit_input_width_class = 'col-md-4';
}
else
{
    $unit_input_width_class = 'col-md-2';
}
?>
<span class="display-none" id="batch-items-json"><?= $batch_valid; ?></span>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>

        <div class="text-<?php if($app_direction == 'rtl'){echo 'left';}else{echo 'right';} ?>">
            <input style="width: 100px; border: none; background: #e0e0e0; padding: 9px 5px; text-align: center; border-radius: 2px; color: black;" type="text" class="pointer-none" value="<?= print_lang($app_lang,'add_entry_sr_num').' '.get_serial_id('purchases'); ?>" readonly="">
        </div>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="temp-purchases-form">
                    <div class="row " style="margin-bottom: 5px;">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-3 fixed-fields-row">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select temp_supplier_edit" name="temp_supplier">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                                            <?php foreach($suppliers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name'].' ( Supplier)'; ?></option>
                                            <?php } ?>
                                            <?php if($item_settings['b_to_b_business'] == 'enable'){?>
                                                <?php foreach($clients as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>"><?= $row['name'].' ( Client)'; ?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'invoice'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="temp_invoice" placeholder="<?= print_lang($app_lang,'invoice_#'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'date'); ?></label>
                                        <?php 
                                            $edate = display_true_date( date('y-m-d') );
                                            $edate = true_date_for_inputs($edate);
                                        ?>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" name="temp_pdate" value="<?php echo $edate; ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="temp_pdate" value="<?php echo date("Y-m-d",strtotime($edate)); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if($item_settings['cbm'] == 'enable'){ $col_memo = '3'; }else{$col_memo = '4';}?>
                        <div class="col-md-<?= $col_memo; ?>">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'memo'); ?></label>
                                <textarea style="height: 35px;" class="form-control temp_p_memo_edit" name="temp_memo" rows="1" placeholder="<?= print_lang($app_lang,'memo'); ?>"></textarea>
                            </div>
                        </div>
                        <?php if($item_settings['cbm'] == 'enable'){ ?>
                            <div class="col-md-1" style="padding: 2px; margin-top: 20px;">
                                <button type="button" class="btn btn-primary purchase-cbm-popup-trigger"><?= print_lang($app_lang,'purchase_cbm_info'); ?></button>
                            </div>
                        <?php } ?>
                    </div>                    

                    <div class="row" style="margin-bottom: 5px;">

                        <?php 
                            if($item_settings['distribution'] == 'disable')
                            {
                                $col_length = 3;
                                $col_length_ex = 2;
                            }
                            else
                            {
                                $col_length = 2;
                                $col_length_ex = 1;
                            }
                        ?>
                        <div class="col-md-<?= $col_length; ?>" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_item" id="purchases-temp-item">
                                    <option disabled="" selected="" value="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php foreach($items as $row){
                                        $item_stats = json_decode($row['stats'],true);
                                        $item_tp = (float)$item_stats['last_cost'] + (float)$item_stats['last_profit'];
                                    ?>
                                        <option value="<?= $row['uid']; ?>" data-item-cbm-width="<?= $row['item_width']; ?>" data-item-cbm-length="<?= $row['item_length']; ?>" data-item-cbm-height="<?= $row['item_height']; ?>" data-item-cbm="<?= $row['cbm']; ?>" data-item-weight="<?= $row['weight']; ?>" data-last-cost="<?= $item_stats['last_cost']; ?>" data-tp="<?= $item_tp; ?>" data-last-profit="<?= $item_stats['last_profit']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name'].' - '.$row['details'].' - '.$row['item_id']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-<?= $col_length; ?>" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_warehouse">
                                    <option disabled="" selected="" data-opt-type="default">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                    <?php foreach($warehouse as $row){ ?>
                                        <option class="display-none" value="<?= $row['uid']; ?>" data-opt-type="<?= $row['type']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-<?= $col_length; ?>" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'batch'); ?></label>
                                <input type="text" class="form-control" name="temp_batch" placeholder="<?= print_lang($app_lang,'batch'); ?>">
                            </div>
                        </div>

                        <?php if($item_settings['distribution'] == 'enable'){ ?>
                            <div class="col-md-2" style="padding: 2px;">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'mfg_date'); ?></label>
                                    <?php if($branch_calander == 'persian'){ ?>
                                        <input type="text" class="form-control persian-date" name="temp_mfg" placeholder="<?= print_lang($app_lang,'mfg_date'); ?>" readonly="" style="background: #fff;">
                                    <?php }else{ ?>
                                        <input type="date" class="form-control" name="temp_mfg">
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-md-2" style="padding: 2px;">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'expiry_date'); ?></label>
                                    <?php if($branch_calander == 'persian'){ ?>
                                        <input type="text" class="form-control persian-date" name="temp_expiry" placeholder="<?= print_lang($app_lang,'expiry_date'); ?>" readonly="" style="background: #fff;">
                                    <?php }else{ ?>
                                        <input type="date" class="form-control" name="temp_expiry">
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="col-md-<?= $col_length; ?>" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'expense_account'); ?></label>
                                <select class="form-control chosen-select" name="temp_expense">
                                    <option class="purchase-exp-first-opt" disabled="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                    <?php foreach($transits as $row){ ?>
                                        <option class="display-none" value="<?= $row['uid']; ?>" data-pending="<?= round_decimels_digits_3($row['pending']); ?>" data-currency="<?= $row['currency']; ?>" data-serial="<?= $row['serial_num']; ?>" data-symbol="<?= array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL; ?>">TS# <?= $row['serial_num']; ?> - <?= array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['symbol'] : NULL; ?><?= round_decimels_digits_3($row['pending']); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'cost'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="temp_cost" placeholder="<?= print_lang($app_lang,'cost'); ?>">
                            </div>
                        </div>
                        <?php if($item_settings['item_measurements'] != 'get'){ ?>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                </div>
                            </div>
                        <?php } ?>
                        <div class="<?= $unit_input_width_class; ?>">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_unit">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'unit'); ?> --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-1" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'discount'); ?></label>
                                <input type="number" class="form-control" name="temp_discount" placeholder="<?= print_lang($app_lang,'discount'); ?>">
                            </div>
                        </div>
                        <div class="col-md-1" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'bonus'); ?></label>
                                <input type="number" class="form-control" name="temp_bonus" placeholder="<?= print_lang($app_lang,'bonus'); ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'profit'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="temp_profit" placeholder="<?= print_lang($app_lang,'profit'); ?>">
                            </div>
                        </div>

                        <?php if($item_settings['distribution'] == 'enable'){ ?>
                            <div class="col-md-1" style="padding: 2px;">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'tp_field'); ?><strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control" name="temp_tp" placeholder="<?= print_lang($app_lang,'tp_field'); ?>">
                                </div>
                            </div>
                        <?php } ?>
                        
                        <div class="col-md-<?= $col_length_ex; ?>" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'transport_expenses'); ?></label>
                                <input type="number" class="form-control" name="temp_transport_expense" placeholder="<?= print_lang($app_lang,'transport_expenses'); ?>">
                            </div>
                        </div>
                    </div>

                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                        <div class="row" style="margin-bottom: 5px;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'width'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_width" placeholder="<?= print_lang($app_lang,'width'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'height'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_height" placeholder="<?= print_lang($app_lang,'height'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control purchase-item-qty-iput" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'m2'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control purchase-item-m2-iput" name="temp_m2" placeholder="<?= print_lang($app_lang,'m2'); ?>">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_to_purchase'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="purchases-form" action="<?php echo url('/purchases/save'); ?>">
            <input type="hidden" name="system_item_token" id="system_item_token" value="<?= $item_settings['item_token']; ?>">
            <input type="hidden" name="system_bundle_toop" id="system_bundle_toop" value="<?= $item_settings['bundle_toop']; ?>">
            <input type="hidden" name="system_distribution" id="system_distribution" value="<?= $item_settings['distribution']; ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'token_thead_rate'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'real_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'token_thead'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <?php if($item_settings['distribution'] == 'enable'){ ?>
                                        <th class="text-center p-tp-col"><?= print_lang($app_lang,'tp_thead'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['bundle_toop'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'bundle_thead'); ?></th>
                                        <th class="text-center"><?= print_lang($app_lang,'toop_thead'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'transport_expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="purchases-table-body">
                                
                            </tbody>
                        </table>    
                    </div>
                </div>

                <div class="col-md-12 purchases-totals-col">
                    <div class="row">
                        <div class="col-md-2 purchase-total-cel purchases-total-amount-row">
                            <strong><?= print_lang($app_lang,'total'); ?>: </strong>
                            <span class="cals-span"></span>
                            <input class="cals-input" type="hidden" name="grand_total">
                        </div>
                        <div class="col-md-2 purchase-total-cel purchases-discount-amount-row">
                            <strong><?= print_lang($app_lang,'discount'); ?>: </strong>
                            <span class="cals-span"></span>
                            <input class="cals-input" type="hidden" name="discount_amount">
                        </div>
                        <div class="col-md-2 purchase-total-cel purchases-sub-total-row">
                            <strong><?= print_lang($app_lang,'sub_total'); ?>: </strong>
                            <span class="cals-span"></span>
                            <input class="cals-input" type="hidden" name="sub_total_amount">
                        </div>
                        <div class="col-md-2 purchase-total-cel purchases-paid-amount-row">
                            <strong><?= print_lang($app_lang,'paid'); ?>: </strong>
                            <input class="cals-input" type="number" name="paid_amount" style="width: 80px;position: relative;bottom: 4px;border: none;border-bottom: 1px solid #555;">
                            <select class="form-group chosen-select" name="cash_paid_account">
                                <option disabled="" selected="">- <?= print_lang($app_lang,'account'); ?> -</option>
                                <?php foreach($accounts as $row){ ?>
                                <?php if($row['type'] == 'bank' OR $row['type'] == 'cashbook'){?>
                                    <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                <?php }} ?>
                            </select>
                        </div>
                        <div class="col-md-2 purchase-total-cel purchases-remaining-amount-row">
                            <strong><?= print_lang($app_lang,'pending'); ?>: </strong>
                            <span class="cals-span"></span>
                            <input class="cals-input" type="hidden" name="pending_amount">
                        </div>
                        <div class="col-md-2 purchase-total-cel purchases-trans-expense-row">
                            <strong><?= print_lang($app_lang,'transport_expenses'); ?>: </strong>
                            <span class="cals-span"></span>
                            <input class="cals-input" type="hidden" name="trans_exp_amount">
                        </div>
                        <div class="col-md-12" style="margin-top: 20px;">
                            <input type="submit" style="width: 100%;" class="btn btn-primary" value="<?= print_lang($app_lang,'save_print'); ?>">
                        </div>
                    </div>
                </div>

            </div>
        </form>

    </div>

</div>


<div class="modal inmodal fade" id="purchaseCbmPopup" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="padding: 10px !important;">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title" style="font-size: 20px !important;"><?= print_lang($app_lang,'purchase_cbm_popup_title'); ?></h4>
                <small class="font-bold"></small>
            </div>
            <form role="form" id="purchases-cbm-weight-form" action="<?php echo url('/purchases/save-cbm-weight'); ?>">
                <div class="modal-body bg-white">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4><?= print_lang($app_lang,'purchase_cbm_popup_previous_details_title'); ?></h4>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'purchase_cbm_popup_item_width'); ?></label>
                                        <input type="text" class="form-control pointer-none" name="old_width" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_width'); ?>" readonly>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'purchase_cbm_popup_item_height'); ?></label>
                                        <input type="text" class="form-control pointer-none" name="old_height" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_height'); ?>" readonly>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'purchase_cbm_popup_item_length'); ?></label>
                                        <input type="text" class="form-control pointer-none" name="old_length" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_length'); ?>" readonly>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'purchase_cbm_popup_item_cbm'); ?></label>
                                        <input type="text" class="form-control pointer-none" name="old_cbm" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_cbm'); ?>" readonly>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'purchase_cbm_popup_item_weight'); ?></label>
                                        <input type="text" class="form-control pointer-none" name="old_weight" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_weight'); ?>" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="col-md-12">
                                <h4><?= print_lang($app_lang,'purchase_cbm_popup_new_details_title'); ?></h4>
                                <input type="hidden" name="item">
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_cbm_popup_item_width'); ?></label>
                                    <input type="text" class="form-control" name="width" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_width'); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_cbm_popup_item_height'); ?></label>
                                    <input type="text" class="form-control" name="height" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_height'); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_cbm_popup_item_length'); ?></label>
                                    <input type="text" class="form-control" name="length" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_length'); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_cbm_popup_item_cbm'); ?></label>
                                    <input type="text" class="form-control" name="cbm" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_cbm'); ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'purchase_cbm_popup_item_weight'); ?></label>
                                    <input type="text" class="form-control" name="weight" placeholder="<?= print_lang($app_lang,'purchase_cbm_popup_item_weight'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-dismiss="modal"><?= print_lang($app_lang,'purchase_cbm_popup_close_btn'); ?></button>
                    <button type="submit" class="btn btn-primary"><?= print_lang($app_lang,'purchase_cbm_popup_save_btn'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>