<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'purchases'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'purchases'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_purchase') === TRUE){ ?>
                <a href="<?= url('/purchases/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_purchase'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'purchases_listing'); ?></h2>

                    <form id="purchases-search-form" action="<?= url('/purchases'); ?>">
                        <input type="hidden" name="status" value="<?= $search_status; ?>">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'convert_currency'); ?></label>
                                <select class="form-control chosen-select" name="convert_currency">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'convert_currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_convert_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'account'); ?></label>
                                <select class="form-control chosen-select" name="supplier">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                                    <?php foreach($suppliers as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Supplier)'; ?></option>
                                    <?php } ?>
                                    <?php foreach($clients as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Client)'; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'user'); ?></label>
                                <select class="form-control chosen-select" name="user">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'user'); ?> --</option>
                                    <?php foreach($users as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_user == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'from'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                <?php } ?>
                            </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'to'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-4 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                            
                        </div>
                    </div>
                    
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'ref_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'paid'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'pending'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'transport_expenses'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'supplier'); ?></th>
                                    <th class="text-center display-none"><?= print_lang($app_lang,'status'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'by'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sub_total_amount_total = array();
                                $paid_amount_total = array();
                                $pending_amount_total = array();
                                $discount_amount_total = array();
                                $transport_expense_total = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                    $sub_total_amount = $row['sub_total_amount'];
                                    $paid_amount = $row['paid_amount'];
                                    $pending_amount = $row['pending_amount'];
                                    $discount_amount = $row['discount_amount'];
                                    $transport_expense = $row['transport_expense'];
                                    if(!empty($search_convert_currency))
                                    {
                                        $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                        $currency_show = $convert_currency_record['name'];
                                        $amount_currency_equalance = $row['currency_usd_equalance'];
                                        $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                        if($row['currency'] == $search_convert_currency)
                                        {
                                            $amount_currency_equalance = 1;
                                            $convert_currency_equalance = 1;
                                        }
                                        
                                        $sub_total_amount = amount_conversion($row['sub_total_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                        $paid_amount = amount_conversion($row['paid_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                        $pending_amount = amount_conversion($row['pending_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                        $discount_amount = amount_conversion($row['discount_amount'], $amount_currency_equalance, $convert_currency_equalance);
                                        $transport_expense = amount_conversion($row['transport_expense'], $amount_currency_equalance, $convert_currency_equalance);
                                        
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= print_lang($app_lang,'ledgers_module_wise_sr_prefix_purchases').''.$row['serial_id']; ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= round_decimels_digits($sub_total_amount); $sub_total_amount_total[] = (float)$sub_total_amount; ?></td>
                                        <td><?= round_decimels_digits($paid_amount); $paid_amount_total[] = (float)$paid_amount; ?></td>
                                        <td><?= round_decimels_digits($pending_amount); $pending_amount_total[] = (float)$pending_amount; ?></td>
                                        <td><?= round_decimels_digits($discount_amount); $discount_amount_total[] = (float)$discount_amount; ?></td>
                                        <td><?= round_decimels_digits($transport_expense); $transport_expense_total[] = (float)$transport_expense; ?></td>
                                        <td>
                                            <?= array_key_exists($row['supplier'], $suppliers) ? $suppliers[$row['supplier']]['name'] : NULL; ?>
                                            <?= array_key_exists($row['supplier'], $clients) ? $clients[$row['supplier']]['name'] : NULL; ?>
                                        </td>

                                        <td class="display-none">
                                                <a href="javascript:void(0);" data-url="<?= url('/purchases/update-status').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger url-elem purchase-pending-item <?php if($row['status'] != 'pending'){ echo 'display-none'; } ?>"><i class="fa fa-refresh">&nbsp; </i><?= print_lang($app_lang,'pending'); ?></a>
                                                <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-primary url-elem purchase-passed-item <?php if($row['status'] == 'pending'){ echo 'display-none'; } ?>"><i class="fa fa-check">&nbsp; </i><?= print_lang($app_lang,'passed'); ?></a>
                                        </td>

                                        <td><?= $row['user_name']; ?></td>

                                        <td>
                                            <?php if($row['main_approval'] == 'approved'){?>
                                                <?php if(check_user_access('add_purchase') === TRUE){ ?>
                                                    <a href="<?= url('/purchases/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link">&nbsp; </i><?= print_lang($app_lang,'invoice'); ?></a>
                                                <?php } ?>
                                                <?php if(check_user_access('edit_purchase') === TRUE){ ?>
                                                    <a href="<?= url('/purchases/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                                <?php } ?>
                                                <?php if(check_user_access('delete_purchase') === TRUE){ ?>
                                                    <a href="<?= url('/purchases/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                                <?php } ?>
                                            <?php }else{ ?>
                                                <a href="javascript:void(0);" class="btn btn-xs btn-outline btn-warning" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-eye"></i>&nbsp; <?= print_lang($app_lang,'pending'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($sub_total_amount_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($paid_amount_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($pending_amount_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($discount_amount_total)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($transport_expense_total)); ?></td>
                                    <td class="display-none"></td>
                                    <td></td>
                                    <td></td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>