<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'add_quotation'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/quotations'); ?>"><?= print_lang($app_lang,'quotations'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_quotation'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>

<?php
$item_settings = get_item_settings();
if($item_settings['item_measurements'] == 'get')
{
    $items_input_width_class = 'col-md-6';
    $batch_input_width_class = 'col-md-3';
    $unit_input_width_class = 'col-md-3';
}
else
{
    $items_input_width_class = 'col-md-4';
    $batch_input_width_class = 'col-md-2';
    $unit_input_width_class = 'col-md-3';
}
?>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="quotation-temp-form">

                    <div class="row " style="margin-bottom: 5px;">
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4 quotation-fix-row">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>"><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select temp_client_edit_q" name="temp_client" id="quotation-add-client-dropdown">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name'].' ( Client)'; ?></option>
                                            <?php } ?>
                                            <?php foreach($suppliers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name'].' ( Supplier)'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'quotation_num'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control" name="temp_invoice" value="<?= $invoice_number; ?>" placeholder="<?= print_lang($app_lang,'quotation_num'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'memo'); ?></label>
                                <textarea style="height: 35px;" class="form-control temp_memo_edit_q" name="temp_memo" rows="1" placeholder="<?= print_lang($app_lang,'memo'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="<?= $items_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_item">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                            <?php $icount = 1; foreach($items as $row){ ?>
                                                <?php
                                                $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                                foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                                    $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouse) ? $warehouse[$warehouse_uid]['name'] : NULL;
                                                ?>
                                                    <option value="<?= $row['uid']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].', '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="<?= $batch_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'batch'); ?></label>
                                        <select class="form-control chosen-select" name="temp_batch">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_batch'); ?> --</option>
                                            <?php foreach($batch as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <?php if($item_settings['item_measurements'] != 'get'){ ?>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                            <input type="number" class="form-control" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="<?= $unit_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_unit">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'extra_narration'); ?></label>
                                <textarea style="height: 35px;" class="form-control" name="temp_narration" rows="1" placeholder="<?= print_lang($app_lang,'extra_narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                        <div class="row" style="margin-bottom: 5px;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'width'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_width" placeholder="<?= print_lang($app_lang,'width'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'height'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_height" placeholder="<?= print_lang($app_lang,'height'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control sale-item-qty-iput" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'m2'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control sale-item-m2-iput" name="temp_m2" placeholder="<?= print_lang($app_lang,'m2'); ?>">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="row extra-mar-botm" id="cash-sale-client-info-row" style="display: none;">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client_name_sale'); ?></label>
                                <input type="text" name="temp_client_name" class="form-control temp_client_name_edit_q" placeholder="<?= print_lang($app_lang,'client_name_sale'); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client_mob_sale'); ?></label>
                                <input type="text" name="temp_client_mobile" class="form-control temp_client_mobile_edit_q" placeholder="<?= print_lang($app_lang,'client_mob_sale'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_to_quotation'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="quotations-form" action="<?php echo url('/quotations/save'); ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="quotation-items-table-body">
                                
                            </tbody>
                        </table>    
                    </div>

                    <div class="row quotation-under-table-totals">
                        <div class="col-md-3 total-sales-cel">
                            <strong><?= print_lang($app_lang,'total_sale'); ?>: </strong>
                            <span></span>
                            <input type="hidden" name="total_sales_amount">
                        </div>
                        <div class="col-md-3 total-diss-cel">
                            <strong><?= print_lang($app_lang,'total_discount'); ?>: </strong>
                            <span></span>
                            <input type="hidden" name="total_discount_amount">
                        </div>
                        <div class="col-md-3 gross-total-cel">
                            <strong><?= print_lang($app_lang,'gross_total'); ?>: </strong>
                            <span></span>
                            <input type="hidden" name="gross_total_amount">
                        </div>
                        <div class="col-md-3 total-profit-cel">
                            <strong><?= print_lang($app_lang,'total_profit'); ?>: </strong>
                            <span></span>
                            <input type="hidden" name="total_profit_amount">
                        </div>
                    </div>
                </div>

                <div class="col-md-12" style="margin-top: 25px;">
                    <input type="submit" style="width: 100%;" class="btn btn-primary" value="<?= print_lang($app_lang,'save_print'); ?>">
                </div>

            </div>
        </form>

    </div>

</div>