<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'edit_quotation'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/quotations'); ?>"><?= print_lang($app_lang,'quotations'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'edit_quotation'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>

<?php
$item_settings = get_item_settings();
if($item_settings['item_measurements'] == 'get')
{
    $items_input_width_class = 'col-md-6';
    $batch_input_width_class = 'col-md-3';
    $unit_input_width_class = 'col-md-3';
}
else
{
    $items_input_width_class = 'col-md-4';
    $batch_input_width_class = 'col-md-2';
    $unit_input_width_class = 'col-md-3';
}
?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="quotation-temp-form">

                    <div class="row " style="margin-bottom: 5px;">
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4 quotation-fix-row pointer-none">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_currency">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" data-usd-equalance="<?= $row['usd_equalance']; ?>" <?php if($editing_data['currency'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'account'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select temp_client_edit_q" name="temp_client">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Client)'; ?></option>
                                            <?php } ?>
                                            <?php foreach($suppliers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($editing_data['client'] == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Supplier)'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'quotation_num'); ?> <strong class="text-danger">*</strong></label>
                                        <input type="text" class="form-control pointer-none" name="temp_invoice" value="<?= $editing_data['invoice']; ?>" placeholder="<?= print_lang($app_lang,'quotation_num'); ?>" readonly="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'memo'); ?></label>
                                <textarea style="height: 35px;" class="form-control temp_memo_edit_q" name="temp_memo" rows="1" placeholder="<?= print_lang($app_lang,'memo'); ?>"><?= $editing_data['memo']; ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 5px;">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="<?= $items_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_item">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                            <?php $icount = 1; foreach($items as $row){ ?>
                                                <?php
                                                $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                                foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                                    $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouse) ? $warehouse[$warehouse_uid]['name'] : NULL;
                                                ?>
                                                    <option value="<?= $row['uid']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].', '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="<?= $batch_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'batch'); ?></label>
                                        <select class="form-control chosen-select" name="temp_batch">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_batch'); ?> --</option>
                                            <?php foreach($batch as $row){ ?>
                                                <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <?php if($item_settings['item_measurements'] != 'get'){ ?>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                            <input type="number" class="form-control" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="<?= $unit_input_width_class; ?>">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                        <select class="form-control chosen-select" name="temp_unit">
                                            <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'extra_narration'); ?></label>
                                <textarea style="height: 35px;" class="form-control" name="temp_narration" rows="1" placeholder="<?= print_lang($app_lang,'extra_narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                        <div class="row" style="margin-bottom: 5px;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'width'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_width" placeholder="<?= print_lang($app_lang,'width'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'height'); ?></label>
                                    <input type="number" class="form-control pointer-none" name="temp_height" placeholder="<?= print_lang($app_lang,'height'); ?>" readonly="">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control sale-item-qty-iput" name="temp_qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'m2'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="number" class="form-control sale-item-m2-iput" name="temp_m2" placeholder="<?= print_lang($app_lang,'m2'); ?>">
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="row extra-mar-botm" id="cash-sale-client-info-row" <?php if(strpos($editing_data['client'],"CASHSALE") === FALSE){echo "style='display: none'";}else{echo "style='display: block'";} ?>>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client_name_sale'); ?></label>
                                <input type="text" name="temp_client_name" class="form-control temp_client_name_edit_q" placeholder="<?= print_lang($app_lang,'client_name_sale'); ?>" value="<?= $editing_data['cash_client_name']; ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'client_mob_sale'); ?></label>
                                <input type="text" name="temp_client_mobile" class="form-control temp_client_mobile_edit_q" placeholder="<?= print_lang($app_lang,'client_mob_sale'); ?>" value="<?= $editing_data['cash_client_mobile']; ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button style="width: 100%;" class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'add_to_quotation'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>

        <form role="form" id="quotations-form" action="<?php echo url('/quotations/update').'/'.$editing_data['uid']; ?>">
            <div class="row" style="margin-top: 10px;">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody id="quotation-items-table-body">
                                <?php
                                $item_details = json_decode($editing_data['items_details'],true);
                                foreach($item_details as $row){
                                ?>
                                    <tr class="text-center quotation-item-row">
                                        <td class="quotation-item-self">
                                            <span><?= array_key_exists($row['item'], $items) ? $items[$row['item']]['name'] : NULL; ?></span>
                                            <input type="hidden" name="currency[]" value="<?= $editing_data['currency']; ?>">
                                            <input type="hidden" class="client_edit_input_q" name="client[]" value="<?= $editing_data['client']; ?>">
                                            <input type="hidden" name="invoice[]" value="<?= $editing_data['invoice']; ?>">
                                            <input type="hidden" class="memo_edit_input_q" name="memo[]" value="<?= $editing_data['memo']; ?>">
                                            <input type="hidden" name="item[]" value="<?= $row['item']; ?>">
                                            <input type="hidden" name="batch[]" value="<?= $row['batch']; ?>">
                                            <input type="hidden" name="warehouse[]" value="<?= $row['warehouse']; ?>">
                                            <input type="hidden" name="narration[]" value="<?= $row['narration']; ?>">
                                            <input type="hidden" name="m2[]" value="<?= $row['m2']; ?>" class="item-m2-iput">
                                            <input type="hidden" name="width[]" value="<?= $row['width']; ?>" class="item-width-iput">
                                            <input type="hidden" name="height[]" value="<?= $row['height']; ?>" class="item-height-iput">
                                            <input type="hidden" class="cash_client_name_input_q" name="cash_client_name[]" value="<?= $editing_data['cash_client_name']; ?>">
                                            <input type="hidden" class="cash_client_mobile_input_q" name="cash_client_mobile[]" value="<?= $editing_data['cash_client_mobile']; ?>">
                                        </td>
                                        <td class="quotation-item-warehouse">
                                            <span>
                                                <?php
                                                    $sale_item_data = array_key_exists($row['item'], $items) ? $items[$row['item']] : array('purchase_unit' => NULL, 'sale_unit' => NULL, 'production_unit' => NULL);
                                                    $sale_item_unit_name = NULL;
                                                    if($row['unit'] == 'purchase')
                                                    {
                                                        $sale_item_unit_name = array_key_exists($sale_item_data['purchase_unit'],$units) ? $units[$sale_item_data['purchase_unit']]['name'] : NULL;
                                                    }
                                                    if($row['unit'] == 'sale')
                                                    {
                                                        $sale_item_unit_name = array_key_exists($sale_item_data['sale_unit'],$units) ? $units[$sale_item_data['sale_unit']]['name'] : NULL;
                                                    }
                                                    if($row['unit'] == 'production')
                                                    {
                                                        $sale_item_unit_name = array_key_exists($sale_item_data['production_unit'],$units) ? $units[$sale_item_data['production_unit']]['name'] : NULL;
                                                    }
                                                    echo $sale_item_unit_name;
                                                ?>
                                            </span>
                                            <input type="hidden" name="unit[]" value="<?= $row['unit']; ?>">
                                        </td>
                                        <td class="quotation-item-cost">
                                            <span><?= amount_number_format($row['cost']); ?></span>
                                            <input type="hidden" name="cost[]" value="<?= $row['cost']; ?>">
                                        </td>
                                        <td class="quotation-item-sale-price">
                                            <input type="number" name="sale_price[]" value="<?= $row['sale_price']; ?>" class="quotation-editable-iputs">
                                        </td>
                                        <td class="quotation-item-qty">
                                            <input type="number" name="qty[]" value="<?= $row['qty']; ?>" class="quotation-editable-iputs">
                                        </td>
                                        <td class="quotation-item-discount">
                                            <input type="number" name="discount[]" value="<?= $row['discount']; ?>" class="quotation-editable-iputs">
                                        </td>
                                        <td class="quotation-item-profit">
                                            <span><?= amount_number_format($row['profit']); ?></span>
                                            <input type="hidden" name="profit[]" value="<?= $row['profit']; ?>">
                                        </td>
                                        <td class="quotation-item-total">
                                            <span><?= amount_number_format($row['item_total']); ?></span>
                                            <input type="hidden" name="item_total[]" value="<?= $row['item_total']; ?>">
                                        </td>
                                        <td>
                                            <a class="btn btn-danger btn-sm quotation-item-del-trigger" href="javascript:void(0);"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                    <div class="row quotation-under-table-totals">
                        <div class="col-md-3 total-sales-cel">
                            <strong><?= print_lang($app_lang,'total_sale'); ?>: </strong>
                            <span><?= amount_number_format($editing_data['total_sales_amount']); ?></span>
                            <input type="hidden" name="total_sales_amount" value="<?= $editing_data['total_sales_amount']; ?>">
                        </div>
                        <div class="col-md-3 total-diss-cel">
                            <strong><?= print_lang($app_lang,'total_discount'); ?>: </strong>
                            <span><?= amount_number_format($editing_data['total_discount_amount']); ?></span>
                            <input type="hidden" name="total_discount_amount" value="<?= $editing_data['total_discount_amount']; ?>">
                        </div>
                        <div class="col-md-3 gross-total-cel">
                            <strong><?= print_lang($app_lang,'gross_total'); ?>: </strong>
                            <span><?= amount_number_format($editing_data['gross_total_amount']); ?></span>
                            <input type="hidden" name="gross_total_amount" value="<?= $editing_data['gross_total_amount']; ?>">
                        </div>
                        <div class="col-md-3 total-profit-cel">
                            <strong><?= print_lang($app_lang,'total_profit'); ?>: </strong>
                            <span><?= amount_number_format($editing_data['total_profit_amount']); ?></span>
                            <input type="hidden" name="total_profit_amount" value="<?= $editing_data['total_profit_amount']; ?>">
                        </div>
                    </div>

                </div>

                <div class="col-md-12" style="margin-top: 25px;">
                    <input type="submit" style="width: 100%;" class="btn btn-primary" value="<?= print_lang($app_lang,'update'); ?>">
                </div>

            </div>
        </form>

    </div>

</div>