<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'quotations'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'quotations'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_sale') === TRUE){ ?>
                <a href="<?= url('/quotations/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'new_quotation'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'quotations_listing'); ?></h2>

                    <form id="sales-search-form" action="<?= url('/quotations'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="client">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'supplier_client'); ?> --</option>
                                            <?php foreach($clients as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Client)'; ?></option>
                                            <?php } ?>
                                            <?php foreach($suppliers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name'].' ( Supplier)'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="#" data-date="<?= display_true_date(date('Y-m-d')); ?>" class="today-date-form-trigger btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'quotation_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'quotation_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'quotation_gross'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'profit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'memo'); ?></th>
                                    <th class="text-center" style="min-width: 120px; max-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_sales_amount = array();
                                $total_gross_sales_amount = array();
                                $total_received_amount = array();
                                $total_remaining_amount = array();
                                $total_trans_exp_amount = array();
                                $total_profit_amount = array();
                                $total_discount_amount = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){

                                        $row_sub_total = $row['gross_total_amount'];
                                        $row_gross_sub_total = $row['total_sales_amount'];
                                        $row_total_profit_amount = $row['total_profit_amount'];
                                        $row_total_discount_amount = $row['total_discount_amount'];

                                        $total_sales_amount[] = $row_sub_total;
                                        $total_gross_sales_amount[] = $row_gross_sub_total;
                                        $total_profit_amount[] = $row_total_profit_amount;
                                        $total_discount_amount[] = $row_total_discount_amount;

                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td>
                                            <?php 
                                            if(strpos($row['client'],"CASHSALE") === FALSE){
                                                echo array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; 
                                            }
                                            else
                                            {
                                                echo $row['cash_client_name'];
                                            }

                                            ?>
                                            <?= array_key_exists($row['client'], $suppliers) ? $suppliers[$row['client']]['name'] : NULL; ?>
                                        </td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($row_gross_sub_total); ?></td>
                                        <td><?= round_decimels_digits($row_total_discount_amount); ?></td>
                                        <td><?= round_decimels_digits($row_sub_total); ?></td>
                                        <td><?= round_decimels_digits($row_total_profit_amount); ?></td>
                                        <td><?= $row['memo']; ?></td>
                                        <td>
                                            <?php if(check_user_access('add_quotation') === TRUE){ ?>
                                                <a href="<?= url('/sales/add').'?quotation='.$row['uid']; ?>" class="btn btn-xs btn-outline btn-success url-elem"><i class="fa fa-eercast"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('add_quotation') === TRUE){ ?>
                                                <a href="<?= url('/quotations/deliver-note').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-success url-elem"><i class="fa fa-truck"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('add_quotation') === TRUE){ ?>
                                                <a href="<?= url('/quotations/invoice').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('edit_quotation') === TRUE){ ?>
                                                <a href="<?= url('/quotations/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil"></i></a>
                                            <?php } ?>
                                            <?php if(check_user_access('delete_quotation') === TRUE){ ?>
                                                <a href="<?= url('/quotations/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger"><i class="fa fa-trash"></i></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_gross_sales_amount)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_discount_amount)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_sales_amount)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_profit_amount)); ?></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>