<?php if(is_customer_user() === true OR is_sales_man_user() === true){ ?>
<style type="text/css">
  .navbar-default.navbar-static-side{display: none !important;}
  #page-wrapper{width: 100%; margin: 0;}
  .footer.fixed{margin: 0;}
</style>
<?php } ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= $breadcrums_title; ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= $breadcrums_title; ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php

$general_inputs_class = 'col-md-9';
$lot_input_class = 'display-none';

if($search_type == 'supplier')
{
    $general_inputs_class = 'col-md-7';
    $lot_input_class = 'col-md-2';
}

?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= $breadcrums_title; ?> <?= print_lang($app_lang,'listing'); ?></h2>

                    <form id="all-accounts-report-search-form" action="<?= url('/reports/accounts'); ?>">
                    <input type="hidden" name="type" value="<?= $search_type; ?>">
                    <input type="hidden" name="ledger_type" value="<?= $search_ledger_type; ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <select class="form-control chosen-select" name="currency">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 <?php if(is_customer_user() === true){echo 'pointer-none'; } ?>">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <select class="form-control chosen-select" name="account">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                                <?php foreach($accounts as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_account == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/reports/accounts_print').'?'.'type='.$search_type.'&currency='.$search_currency.'&from='.$search_from.'&to='.$search_to.'&account='.$search_account.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                        <div class="col-md-1">
                            <?php if($search_type == 'supplier' OR $search_type == 'client'){?>
                                <a target="_blank" href="<?= url('/reports/accounts').'?'.'type='.$search_type.'&currency='.$search_currency.'&from='.$search_from.'&to='.$search_to.'&account='.$search_account.'&ledger_type=detailed'; ?>" class="btn btn-outline btn-warning dim" title="details"><i class="fa fa-eye"></i></a>
                            <?php } ?>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="row">
                        <div class="col-md-12">
                            <table style="width: 100%; margin: 5px 0px; background: #fff;">
                                <tr style="margin: 5px 0px;">
                                    <td style="width: 33.33%; text-align: center;"><span style="color: #bb0d0d !important; padding: 4px;"><strong style="color: #bb0d0d !important; font-size: 15px;"><?= print_lang($app_lang,'ledger_overall_debit'); ?>:</strong></span> <strong style="font-size: 14px;"><?php echo amount_number_format( $totals_Data['debit'] ); ?></strong></td>
                                    <td style="width: 33.33%; text-align: center;"><span style="color: #bb0d0d !important; padding: 4px;"><strong style="color: #bb0d0d !important; font-size: 15px;"><?= print_lang($app_lang,'ledger_overall_credit'); ?>:</strong></span> <strong style="font-size: 14px;"><?php echo amount_number_format( $totals_Data['credit'] ); ?></strong></td>
                                    <td style="width: 33.33%; text-align: center;"><span style="color: #bb0d0d !important; padding: 4px;"><strong style="color: #bb0d0d !important; font-size: 15px;"><?= print_lang($app_lang,'ledger_overall_balance'); ?>:</strong></span> <strong style="font-size: 14px;"><?php echo amount_number_format( $totals_Data['debit'] - $totals_Data['credit'] ); ?></strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'ref_number'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'balance'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'colour'); ?></th>
                                    <th class="text-center" style="min-width: 150px; max-width: 150px;"><?= print_lang($app_lang,'remarks'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $debits = array();
                                $credits = array();
                                    if($start_filter == 'yes'){
                                        $debits[] = $before_filter_balance['debit'];
                                        $credits[] = $before_filter_balance['credit'];
                                ?>
                                    <tr class="text-center">
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td><?= print_lang($app_lang,'previous_balance'); ?></td>
                                        <td><?= amount_number_format($before_filter_balance['debit']); ?></td>
                                        <td><?= amount_number_format($before_filter_balance['credit']); ?></td>

                                        <?php $row_balance = get_ledgers_balance($debits,$credits); ?>
                                        <td style="color: <?= ($row_balance >= 0) ? '#2B9C1B' : '#ec4758'; ?> !important;"><?= amount_number_format($row_balance); ?></td>
                                        <td></td>
                                        <td class="accounts-report-remarks-col"><span></span></td>
                                    </tr>
                                <?php } ?>
                                <?php
                                
                                $i = 1;
                                foreach($pageData as $row){
                                    $edit_url = null;
                                    $ref_prefix = null;
                                    $journal_invoice = null;
                                    $journal_receipt_uid = null;
                                    $journal_receipt = null;
                                    $journal_details = null;
                                    $journal_debit_details = null;
                                    $journal_credit_details = null;
                                    $row_cross_check_data = fetch_table_where('accounts_cross_checks','uid',$row['cc_uid'],true);
                                    $color = isset($row_cross_check_data['color']) ? (empty($row_cross_check_data['color']) ? '#ffffff' : $row_cross_check_data['color']) : '#ffffff';
                                    $remarks = isset($row_cross_check_data['remarks']) ? $row_cross_check_data['remarks'] : NULL;
                                    $is_checked = isset($row_cross_check_data['is_checked']) ? $row_cross_check_data['is_checked'] : 'no';

                                    // amounts
                                    $row_debit = ($_item_settings['item_measurements'] == 'get') ? $row['wim_debit'] : $row['debit'];
                                    $row_credit = ($_item_settings['item_measurements'] == 'get') ? $row['wim_credit'] : $row['credit'];
                                    if($row_debit == 0 AND $row_credit == 0){ continue; }
                                    $debits[] = $row_debit;
                                    $credits[] = $row_credit;

                                    // embed url
                                    $edit_url = url('/').'/'.$row['module_name'].'/edit/'.str_replace('ALE_', '', $row['module_uid']);
                                    $ref_prefix = print_lang($app_lang,'ledgers_module_wise_sr_prefix_'.$row['module_name']);
                                    $row['narration'] = str_replace('__embed_host__', url('/'), $row['narration']);

                                    if($row['module_name'] == 'journal')
                                    {
                                        $journal_data = fetch_table_where('journal','uid',str_replace('ALE_', '', $row['module_uid']),true);
                                        if(!empty($journal_data))
                                        {
                                            $journal_debit_details = isset($journal_data['payment_narration']) ? $journal_data['payment_narration'] : null;
                                            $journal_credit_details = isset($journal_data['receiving_narration']) ? $journal_data['receiving_narration'] : null;
                                            $journal_invoice = isset($journal_data['invoice']) ? $journal_data['invoice'] : null;
                                            $journal_receipt_uid = isset($journal_data['receipt_uid']) ? $journal_data['receipt_uid'] : null;

                                            if(!empty($journal_receipt_uid))
                                            {
                                                $money_receipt_data = fetch_table_where('money_receipts','uid',$journal_receipt_uid,true);
                                                if(!empty($money_receipt_data))
                                                {
                                                    $journal_receipt = isset($money_receipt_data['invoice']) ? $money_receipt_data['invoice'] : null;
                                                }
                                            }
                                        }
                                    }


                                    ?>

                                    <tr class="text-center" style="background: <?= $color ?> !important;">
                                        <td>
                                            <label class="checkbox-inline"><input type="checkbox" class="accounts-report-cross-check-checkbox" value="<?= $row['cc_uid']; ?>" <?php if($is_checked == 'yes'){ echo 'checked="checked"'; } ?>> &nbsp;&nbsp;<?= $i++; ?>&nbsp; </label>
                                        </td>
                                        <td><?= display_true_date(date('Y-m-d h:i:s A',strtotime($row['aldate']))); ?></td>
                                        <td><a href="<?= $edit_url; ?>"><?= $ref_prefix.' '.$row['serial_id']; ?></a></td>
                                        <td>
                                            <?php if($row['module_name'] == 'journal'){?>
                                                <?= 'Journal # '.$journal_invoice; ?><br>
                                                <?php if(!empty($journal_receipt)){?>
                                                <?= 'Receipt # '.$journal_receipt; ?><br>
                                                <?php } ?>
                                                <?php if($row['debit'] != 0){?>
                                                    <?php if(!empty($journal_debit_details)){?>
                                                    <br><?= $journal_debit_details; ?><br>
                                                    <?php } ?>
                                                <?php }else{?>
                                                    <?php if(!empty($journal_credit_details)){?>
                                                    <br><?= $journal_credit_details; ?><br>
                                                    <?php } ?>
                                                <?php } ?>


                                            <?php }else{?>
                                            <?= $row['narration']; ?><br>
                                            <?php } ?>
                                            <?php 
                                                $branch_text = isset($branches[$row['branch']]) ? ucwords($branches[$row['branch']]['branch_name']) : print_lang($app_lang,'customer_ledger_branch_not_found');
                                                $branch_name = print_lang($app_lang,'customer_ledger_branch_name').' '.$branch_text;
                                            ?>
                                            <span class="text-muted" style="font-size: 11px !important; font-weight: 600 !important;"><?php echo $row['module_details']; ?></span>
                                        </td>
                                        <td><?= amount_number_format($row_debit); ?></td>
                                        <td><?= amount_number_format($row_credit); ?></td>

                                        <?php $row_balance = get_ledgers_balance($debits,$credits); ?>
                                        <td style="color: <?= ($row_balance >= 0) ? '#2B9C1B' : '#ec4758'; ?> !important;"><?= amount_number_format($row_balance); ?></td>
                                        <td><input style="width: 40px;" type="color" class="accounts-report-color-iput" value="<?= $color; ?>"></td>
                                        <td class="accounts-report-remarks-col"><span><?= $remarks; ?></span></td>
                                    </tr>

                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d h:i:s A')); ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= amount_number_format(array_sum($debits)); ?></td>
                                    <td><?= amount_number_format(array_sum($credits)); ?></td>

                                    <?php $total_balance = get_ledgers_balance($debits,$credits); ?>
                                    <td style="color: <?= ($total_balance >= 0) ? '#2B9C1B' : '#ec4758'; ?> !important;"><?= amount_number_format($total_balance); ?></td>
                                    <td></td>
                                    <td></td>
                                </tr>>ALPHA SOFTWARE | 0700573290 |Development By En Sudais Noori
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>