<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= $breadcrums_title; ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= $breadcrums_title; ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php

$general_inputs_class = 'col-md-9';
$lot_input_class = 'display-none';

if($search_type == 'supplier')
{
    $general_inputs_class = 'col-md-7';
    $lot_input_class = 'col-md-2';
}

?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= $breadcrums_title; ?> <?= print_lang($app_lang,'listing'); ?></h2>

                    <form id="all-accounts-report-search-form" action="<?= url('/reports/accounts'); ?>">
                    <input type="hidden" name="type" value="<?= $search_type; ?>">
                    <div class="row">
                        <div class="<?= $general_inputs_class; ?>">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <select class="form-control chosen-select" name="currency">
                                                <option disabled="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date" style="width: 100%;">
                                            <select class="form-control chosen-select" name="account">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_account'); ?> --</option>
                                                <?php foreach($accounts_for_filter as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_account == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="<?= $lot_input_class; ?>">
                            <div class="form-group">
                                <div class="input-group date" style="width: 100%;">
                                    <select class="form-control chosen-select" name="lot">
                                        <option value="" selected="">-- <?= print_lang($app_lang,'lot'); ?> --</option>
                                        <option value="singular" <?php if($search_lot == 'singular'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'singular'); ?></option>
                                        <option value="collective" <?php if($search_lot == 'collective'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'collective'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/reports/accounts_print').'?'.'type='.$search_type.'&currency='.$search_currency.'&from='.$search_from.'&to='.$search_to.'&lot='.$search_lot.'&account='.$search_account.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="row">
                        <div class="col-md-12">
                            <table style="width: 100%; margin: 5px 0px; background: #fff;">
                                <tr style="margin: 5px 0px;">
                                    <td style="width: 33.33%; text-align: center;"><span style="color: #bb0d0d !important; padding: 4px;"><strong style="color: #bb0d0d !important; font-size: 15px;"><?= print_lang($app_lang,'ledger_overall_debit'); ?>:</strong></span> <strong style="font-size: 14px;"><?php echo amount_number_format( $totals_Data['parent_ledger_stats']['debit'] ); ?></strong></td>
                                    <td style="width: 33.33%; text-align: center;"><span style="color: #bb0d0d !important; padding: 4px;"><strong style="color: #bb0d0d !important; font-size: 15px;"><?= print_lang($app_lang,'ledger_overall_credit'); ?>:</strong></span> <strong style="font-size: 14px;"><?php echo amount_number_format( $totals_Data['parent_ledger_stats']['credit'] ); ?></strong></td>
                                    <td style="width: 33.33%; text-align: center;"><span style="color: #bb0d0d !important; padding: 4px;"><strong style="color: #bb0d0d !important; font-size: 15px;"><?= print_lang($app_lang,'ledger_overall_balance'); ?>:</strong></span> <strong style="font-size: 14px;"><?php echo amount_number_format( $totals_Data['parent_ledger_stats']['balance'] ); ?></strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'debit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'credit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'balance'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'colour'); ?></th>
                                    <th class="text-center" style="min-width: 150px; max-width: 150px;"><?= print_lang($app_lang,'remarks'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $debits = array();
                                $credits = array();
                                ?>
                                <?php $i = 1; foreach($pageData['child_records'] as $row){ ?>

                                    <?php
                                    $color = array_key_exists($row['uid'],$accounts_cross_checks) ? empty($accounts_cross_checks[$row['uid']]['color']) ? '#ffffff' : $accounts_cross_checks[$row['uid']]['color'] : '#ffffff';
                                    $remarks = array_key_exists($row['uid'],$accounts_cross_checks) ? $accounts_cross_checks[$row['uid']]['remarks'] : NULL;
                                    $is_checked = array_key_exists($row['uid'],$accounts_cross_checks) ? $accounts_cross_checks[$row['uid']]['is_checked'] : 'no';
                                    ?>

                                    <tr class="text-center" style="background: <?= $color ?> !important;">
                                        <td>
                                            <label class="checkbox-inline"><input type="checkbox" class="accounts-report-cross-check-checkbox" value="<?= $row['uid']; ?>" <?php if($is_checked == 'yes'){ echo 'checked="checked"'; } ?>> &nbsp;&nbsp;<?= $i++; ?>&nbsp; </label>
                                        </td>
                                        <td><?= display_true_date(date('Y-m-d h:i:s A',strtotime($row['date']))); ?></td>
                                        <td><?= $row['narration']; ?></td>
                                        <td><?= amount_number_format($row['debit']); $debits[] = $row['debit']; ?></td>
                                        <td><?= amount_number_format($row['credit']); $credits[] = $row['credit']; ?></td>

                                        <?php
                                        // $row_balance = ($search_type == 'client' OR $search_type == 'bank') ? array_sum($debits) - array_sum($credits) : array_sum($credits) - array_sum($debits);
                                        $row_balance = get_ledgers_balance($debits,$credits);
                                        $balance_color = ($row_balance >= 0) ? '#2B9C1B' : '#ec4758';
                                        ?>

                                        <td style="color: <?= $balance_color; ?> !important;"><?= amount_number_format($row_balance); ?></td>
                                        <td><input style="width: 40px;" type="color" class="accounts-report-color-iput" value="<?= $color; ?>"></td>
                                        <td class="accounts-report-remarks-col"><span><?= $remarks; ?></span></td>
                                    </tr>

                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d h:i:s A')); ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= amount_number_format($pageData['parent_ledger_stats']['debit']); ?></td>
                                    <td><?= amount_number_format($pageData['parent_ledger_stats']['credit']); ?></td>

                                    <?php
                                    // $total_balance = ($search_type == 'client' OR $search_type == 'bank') ? array_sum($debits) - array_sum($credits) : array_sum($credits) - array_sum($debits);
                                    $total_balance = get_ledgers_balance($debits,$credits);
                                    $balance_color = ($total_balance >= 0) ? '#2B9C1B' : '#ec4758';
                                    ?>

                                    <td style="color: <?= $balance_color; ?> !important;"><?= amount_number_format($total_balance); ?></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>