<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'audit_report_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'audit_report_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <form id="audit-report-search-form" action="<?= url('/reports/audit'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'audit_report_view_title'); ?></h2>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_time'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_module'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_action'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_view'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'audit_report_thead_user'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $i = 1;
                                
                                foreach($records as $row){
                                    $invoice_url = null;
                                    $invoice_butn = null;

                                    if(!empty($row['url']))
                                    {
                                        if (str_contains($row['url'], 'sales/')) { 
                                            $invoice_url = str_replace('edit', 'invoice', $row['url']);
                                            $invoice_butn = '<a href="'.url('/').$invoice_url.'" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>';
                                        }
                                        if (str_contains($row['url'], 'sales-return/')) { 
                                            $invoice_url = str_replace('edit', 'invoice', $row['url']);
                                            $invoice_butn = '<a href="'.url('/').$invoice_url.'" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>';
                                        }
                                        if (str_contains($row['url'], 'purchases/')) { 
                                            $invoice_url = str_replace('edit', 'invoice', $row['url']);
                                            $invoice_butn = '<a href="'.url('/').$invoice_url.'" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>';
                                        }
                                        if (str_contains($row['url'], 'production/')) { 
                                            $invoice_url = str_replace('edit', 'invoice', $row['url']);
                                            $invoice_butn = '<a href="'.url('/').$invoice_url.'" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>';
                                        }
                                        if (str_contains($row['url'], 'transfer-in/')) { 
                                            $invoice_url = str_replace('edit', 'invoice', $row['url']);
                                            $invoice_butn = '<a href="'.url('/').$invoice_url.'" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>';
                                        }
                                        if (str_contains($row['url'], 'transfer-out/')) { 
                                            $invoice_url = str_replace('edit', 'invoice', $row['url']);
                                            $invoice_butn = '<a href="'.url('/').$invoice_url.'" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i></a>';
                                        }
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['activity_time']); ?></td>
                                        <td><?= date('h:i:s a',strtotime($row['activity_time'])); ?></td>
                                        <td><?= $row['module']; ?></td>
                                        <td><?= $row['activity']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td><?= $invoice_butn; ?></td>
                                        <td><?= $row['user_name']; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>