<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'balance_summary'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'balance_summary'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php $item_settings = get_item_settings(); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'balance_summary_main_heading'); ?></h2>

                    <hr>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_opening_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['opening_stock'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_purchased_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['purchases_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_total_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['total_stock'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_sold_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['sales_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>


                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_damage_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['damage_stock'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_current_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['current_stock'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_profit'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['profit_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <?php
                                        $curr_profit = 0;
                                        if(check_user_access('system_profit') === TRUE){ $curr_profit = $stat_amount; }
                                        ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $curr_profit ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <?php
                                    $curr_profit_in_usd = 0;
                                    if(check_user_access('system_profit') === TRUE){ $curr_profit_in_usd = $stat_all_in_usd; }
                                    ?>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format( $curr_profit_in_usd ); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_bank'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['bank_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_receivable'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $client_stat_array = $_stats['receivable_amount'];
                                    $client_stat_all_in_usd = array_key_exists('all_in_usd',$client_stat_array) ? $client_stat_array['all_in_usd'] : 0;
                                    $current_stat_array = $_stats['type_current_amount'];
                                    $current_stat_all_in_usd = array_key_exists('all_in_usd',$current_stat_array) ? $current_stat_array['all_in_usd'] : 0;
                                    $employee_stat_array = $_stats['type_employee_amount'];
                                    $employee_stat_all_in_usd = array_key_exists('all_in_usd',$employee_stat_array) ? $employee_stat_array['all_in_usd'] : 0;
                                    $tota_receivable_amount_all_in_usd = $client_stat_all_in_usd + $current_stat_all_in_usd + $employee_stat_all_in_usd;
                                    foreach($currencies as $row){
                                        $client_stat_amount = array_key_exists($row['uid'],$client_stat_array) ? $client_stat_array[$row['uid']] : 0;
                                        $current_stat_amount = array_key_exists($row['uid'],$current_stat_array) ? $current_stat_array[$row['uid']] : 0;
                                        $employee_stat_amount = array_key_exists($row['uid'],$employee_stat_array) ? $employee_stat_array[$row['uid']] : 0;
                                        $tota_receivable_amount = $client_stat_amount + $current_stat_amount + $employee_stat_amount;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $tota_receivable_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($tota_receivable_amount_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'supplier_due'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $supplier_stat_array = $_stats['supplier_due_amount'];
                                    $supplier_stat_all_in_usd = array_key_exists('all_in_usd',$supplier_stat_array) ? $supplier_stat_array['all_in_usd'] : 0;

                                    $transit_stat_array = $_stats['transit_due_amount'];
                                    $transit_stat_all_in_usd = array_key_exists('all_in_usd',$transit_stat_array) ? $transit_stat_array['all_in_usd'] : 0;

                                    $tota_payable_amount_all_in_usd = $supplier_stat_all_in_usd + $transit_stat_all_in_usd;
                                    if($tota_payable_amount_all_in_usd < 0){$tota_payable_amount_all_in_usd = abs($tota_payable_amount_all_in_usd);}else{$tota_payable_amount_all_in_usd = '-'.$tota_payable_amount_all_in_usd;}
                                    foreach($currencies as $row){
                                        $supplier_amount = array_key_exists($row['uid'],$supplier_stat_array) ? $supplier_stat_array[$row['uid']] : 0;
                                        $transit_amount = array_key_exists($row['uid'],$transit_stat_array) ? $transit_stat_array[$row['uid']] : 0;
                                        $tota_payable_amount = $supplier_amount + $transit_amount;
                                        if($tota_payable_amount < 0){$tota_payable_amount = abs($tota_payable_amount);}else{$tota_payable_amount = '-'.$tota_payable_amount;}
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $tota_payable_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($tota_payable_amount_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_cash'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['cash_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_expenses'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['expenses_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>


                    <?php if($item_settings['construction'] == 'enable'){ ?>
                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_completed_cost'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['projects_cost'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_pending_amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['projects_pending_amount'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_completed_expenses'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['projects_expenses'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_completed_profit'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['projects_profit'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <?php } ?>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_fixed_assets'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $stat_array = $_stats['fixed_assets'];
                                    $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                    foreach($currencies as $row){
                                        $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                    ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php if($item_settings['service'] == 'enable'){ ?>
                            <div class="col-md-3">
                                <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                    <thead>
                                        <tr>
                                            <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_services'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $stat_array = $_stats['services_amount'];
                                        $stat_all_in_usd = array_key_exists('all_in_usd',$stat_array) ? $stat_array['all_in_usd'] : 0;
                                        foreach($currencies as $row){
                                            $stat_amount = array_key_exists($row['uid'],$stat_array) ? $stat_array[$row['uid']] : 0;
                                        ?>
                                            <tr>
                                                <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                                <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $stat_amount ); ?></h4></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                            <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format($stat_all_in_usd); ?></h4></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php } ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>