<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'balance_summary'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'balance_summary'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php $item_settings = get_item_settings(); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'balance_summary_main_heading'); ?></h2>

                    <hr>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_opening_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['opening_stock']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['opening_stock']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_purchased_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['purchased_stock']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['purchased_stock']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_total_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['total_stock']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['total_stock']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_sold_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['sold_stock']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['sold_stock']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>


                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_damage_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['damage_stock']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['damage_stock']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_current_stock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['current_stock']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['current_stock']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_profit'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['profit']['currencies'] as $row){ ?>
                                        <?php
                                        $curr_profit = 0;
                                        if(check_user_access('system_profit') === TRUE)
                                        {
                                            $curr_profit = isset($row['stock_cost']) ? array_sum($row['stock_cost']) : 0;
                                        }
                                        ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( $curr_profit ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <?php
                                    $curr_profit_in_usd = 0;
                                    if(check_user_access('system_profit') === TRUE)
                                    {
                                        $curr_profit_in_usd = array_sum($boxes['profit']['all_in_usd']);
                                    }
                                    ?>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format( $curr_profit_in_usd ); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_bank'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['bank']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stats']) ? $row['stats'] : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['bank']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_receivable'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['receivable']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stats']) ? $row['stats'] : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['receivable']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'supplier_due'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['payable']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['payable']) ? array_sum($row['payable']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['payable']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_cash'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['cashbook']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stats']) ? $row['stats'] : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['cashbook']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_expenses'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['expenses']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['stats']) ? $row['stats'] : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['expenses']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_fixed_assets'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['fixed_assets']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['asset_amount']) ? array_sum($row['asset_amount']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['fixed_assets']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_other_accounts'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['other_accounts']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['account_balance']) ? array_sum($row['account_balance']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['other_accounts']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_current_assets'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['current_assets']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['current_assets']) ? array_sum($row['current_assets']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['current_assets']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_liabilities'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['real_liability']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['lib']) ? $row['lib'] : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['real_liability']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>


                    <?php if($item_settings['construction'] == 'enable'){ ?>
                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_completed_cost'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['projects_cost']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['amount']) ? array_sum($row['amount']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['projects_cost']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_pending_amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['projects_pending_amount']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['amount']) ? array_sum($row['amount']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['projects_pending_amount']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_completed_expenses'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['projects_expenses']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['amount']) ? array_sum($row['amount']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['projects_expenses']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'balance_summary_projects_completed_profit'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['projects_profit']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['amount']) ? array_sum($row['amount']) : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['projects_profit']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <?php } ?>

                    <div class="row" style="margin-bottom: 10px;">
                        <div class="col-md-3">
                            <table class="table table-stripped small" style="width: 100%; <?php if($app_direction == 'rtl'){echo 'float: right; margin-left: 3%;';}else{echo 'float: left; margin-right: 3%;';} ?>">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="border: 1px solid black !important; background: black !important; color: #fff !important; padding: 4px 8px 4px 8px !important;"><?= print_lang($app_lang,'boxes_equity'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($boxes['equity']['currencies'] as $row){ ?>
                                        <tr>
                                            <td style="width: 20%; padding: 1px 8px 1px 8px !important;" class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= $row['name']; ?></h4></td>
                                            <td style="width: 80%; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?> " class="no-borders"><h4 style="border-bottom: 1px solid lightgray;"><?= amount_number_format( isset($row['equity']) ? $row['equity'] : 0 ); ?></h4></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="width: 60%; background: #e4ce35 !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important;"><h4 style="margin: 4px; border-bottom: 1px solid black; color: black; font-size: 13px; font-style: italic;"><?= print_lang($app_lang,'total_by_usd'); ?></h4></td>
                                        <td style="width: 40%; background: gray !important; color: #fff !important; border: none !important; padding: 1px 8px 1px 8px !important; <?php if($app_direction == 'rtl'){echo 'text-align: left;';}else{echo 'text-align: right;';} ?>"><h4 style="margin: 4px; border-bottom: 1px solid lightgray;"><?= amount_number_format(array_sum($boxes['equity']['all_in_usd'])); ?></h4></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>