<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'batch_rep_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'batch_rep_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'batch_rep_view_title'); ?></h2>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_batch'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'batch_rep_view_thead_mfg'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'batch_rep_view_thead_expiry'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tin'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tout'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_damage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_ava'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_value'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $i = 1; 
                                $active_branch_id = active_branch_id();
                                $stock_in = 0;
                                $stock_out = 0;
                                $bonus_in = 0;
                                $bonus_out = 0;
                                $cost = 0;
                                $value = 0;
                                $stock_ava = 0;
                                $total_stock = array();
                                $total_stock_in = array();
                                $total_transfer_in = array();
                                $total_stock_out = array();
                                $total_stock_return = array();
                                $total_transfer_out = array();
                                $total_damage_out = array();
                                $total_stock_ava = array();
                                $total_stock_tp = array();

                                foreach($pageData as $row){
                                    $item = fetch_table_where('items','uid',$row['item'],true);
                                    $item_currency = $item['currency'];
                                    $item_currency_usd_equalance = (float)$item['currency_usd_equalance'];

                                    $item_stock_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','items')->where('status','passed')->sum('stock_in');

                                    $purchases_stock_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','purchases')->where('status','passed')->sum('stock_in');
                                    $purchases_bonus_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','purchases')->where('status','passed')->sum('bonus_in');
                                    
                                    $return_stock_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','sales_return')->where('status','passed')->sum('stock_in');

                                    $transfer_stock_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_in')->where('status','passed')->sum('stock_in');
                                    $transfer_bonus_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_in')->where('status','passed')->sum('bonus_in');

                                    $sales_stock_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','sales')->where('status','passed')->sum('stock_out');
                                    $sales_bonus_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','sales')->where('status','passed')->sum('bonus_out');

                                    $transfer_stock_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_out')->where('status','passed')->sum('stock_out');
                                    $transfer_bonus_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_out')->where('status','passed')->sum('bonus_out');

                                    $damage_stock_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','damage')->where('status','passed')->sum('stock_out');

                                    $item_last_batch_tp = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('module','!=','sales')->where('module','!=','damage')->where('module','!=','transfer_out')->whereNotNull('sale_price')->orderBy('module_created_at','desc')->orderBy('id','desc')->get()->first());
                                    $item_tp = (float)$item_last_batch_tp['sale_price'];
                                    $batch_currency = $item_last_batch_tp['currency'];
                                    $batch_currency_equalance = (float)$item_last_batch_tp['currency_usd_equalance'];

                                    if($batch_currency == $item_currency)
                                    {
                                        // no conversion
                                        $item_tp = $item_tp;
                                    }
                                    else
                                    {
                                        // apply conversion
                                        $item_tp = amount_conversion($item_tp, $batch_currency_equalance, $item_currency_usd_equalance);
                                    }

                                    // $bonus_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('status','passed')->sum('bonus_in');
                                    // $stock_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('status','passed')->sum('stock_out');
                                    // $bonus_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where('status','passed')->sum('bonus_out');

                                    $mfg_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where("module",'!=','sales')->where('status','passed')->where("module",'!=','transfer_out')->where("module",'!=','damage')->whereNotNull('mfg_date')->orderBy('module_created_at','desc')->get()->first());
                                    if(empty($mfg_batch['mfg_date']))
                                    {
                                        $mfg_date = '';
                                    }
                                    else
                                    {
                                        $mfg_date = $mfg_batch['mfg_date'];    
                                    }

                                    $expiry_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$row['item'])->where('batch',$row['batch'])->where("module",'!=','sales')->where('status','passed')->where("module",'!=','transfer_out')->where("module",'!=','damage')->whereNotNull('expiry_date')->orderBy('module_created_at','desc')->get()->first());
                                    if(empty($expiry_batch['expiry_date']))
                                    {
                                        $expiry_date = '';
                                    }
                                    else
                                    {
                                        $expiry_date = $expiry_batch['expiry_date'];    
                                    }
                                    // $expiry_date = $expiry_batch['expiry_date'];
                                    
                                    $stock_in_total = (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in;

                                    $stock_out_total = (float)$sales_stock_out + (float)$sales_bonus_out;
                                    
                                    $transfer_out_total = (float)$transfer_stock_out + (float)$transfer_bonus_out;
                                    $transfer_in_total = (float)$transfer_stock_in + (float)$transfer_bonus_in;

                                    $stock_ava = $stock_in_total + (float)$transfer_in_total + (float)$return_stock_in - $stock_out_total - $transfer_out_total - (float)$damage_stock_out;

                                    if($stock_ava > 0){

                                    $cost = (float)$item['_avg_cost'];
                                    // $value = $stock_ava * $cost;
                                    $value = $stock_ava * $item_tp;
                                    $total_stock[] = $value;
                                    $total_stock_in[] = $stock_in_total;
                                    $total_transfer_in[] = $transfer_in_total;
                                    $total_stock_out[] = $stock_out_total;
                                    $total_stock_return[] = $return_stock_in;
                                    $total_transfer_out[] = $transfer_out_total;
                                    $total_damage_out[] = $damage_stock_out;
                                    $total_stock_ava[] = $stock_ava;
                                    $total_stock_tp[] = $item_tp;
                                    $name = $item['name'];
                                    $expiry = display_true_date($expiry_date);
                                    $unit = array_key_exists($item['purchase_unit'], $units) ? $units[$item['purchase_unit']]['short'] : NULL;
                                    
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $name; ?></td>
                                        <td><?= $unit; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?php if(!empty($mfg_date)){echo display_true_date($mfg_date);}; ?></td>
                                        <td><?php if(!empty($expiry_date)){echo display_true_date($expiry_date);}; ?></td>
                                        <td><?= amount_number_format($stock_in_total); ?></td>
                                        <td><?= amount_number_format($stock_out_total); ?></td>
                                        <td><?= amount_number_format($return_stock_in); ?></td>
                                        <td><?= amount_number_format($transfer_in_total); ?></td>
                                        <td><?= amount_number_format($transfer_out_total); ?></td>
                                        <td><?= amount_number_format($damage_stock_out); ?></td>
                                        <td><?= amount_number_format($stock_ava); ?></td>
                                        <td><?= amount_number_format($item_tp); ?></td>
                                        <td><?= amount_number_format($value); ?></td>
                                    </tr>
                                <?php }} ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock_in)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock_out)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock_return)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_transfer_in)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_transfer_out)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_damage_out)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock_ava)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock_tp)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>