<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'bundle_item_report_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'bundle_item_report_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'bundle_item_report_title'); ?></h2>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_bundle_stock_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_bundle_stock_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_bundle_stock_ava'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_toop_stock_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_toop_stock_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bundle_item_report_thead_toop_stock_ava'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $i = 1; 
                                $bundle_available = 0;
                                $toop_available = 0;
                                foreach($pageData as $row){                                    
                                    $bundle_available = (float)$row['bundle_stock_in_total'] - (float)$row['bundle_stock_out_total'];
                                    $toop_available = (float)$row['toop_stock_in_total'] - (float)$row['toop_stock_out_total'];
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= amount_number_format($row['bundle_stock_in_total']); ?></td>
                                        <td><?= amount_number_format($row['bundle_stock_out_total']); ?></td>
                                        <td><?= amount_number_format($bundle_available); ?></td>
                                        <td><?= amount_number_format($row['toop_stock_in_total']); ?></td>
                                        <td><?= amount_number_format($row['toop_stock_out_total']); ?></td>
                                        <td><?= amount_number_format($toop_available); ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>