<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'client_items_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'client_items_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'client_items_report'); ?></h2>

                    <form id="client-items-report-search-form" action="<?= url('/reports/client-items'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="client">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_client'); ?> --</option>
                                                <?php foreach($clients as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_client == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'category'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'discount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sales_total = array();
                                $sales_total_qty = array();
                                $sales_total_amount = array();
                                $sales_total_discount = array();
                                $i = 1;
                                foreach($pageData as $row)
                                {
                                    $item_details = json_decode($row['items_details'],true);
                                    foreach($item_details as $inner_row)
                                    {
                                        if(!empty($search_item))
                                        {
                                            if($inner_row['item'] != $search_item){ continue; }
                                        }

                                        $item_total_amount = (float)$inner_row['item_total'];
                                        $item_qty = (float)$inner_row['qty'];
                                        $item_sale_price = (float)$inner_row['sale_price'];
                                        $item_discount_per = (float)$inner_row['discount'];

                                        $item_discount_amount = ($item_sale_price * $item_discount_per) / 100;
                                        $item_total_sale_price = $item_sale_price * $item_qty;
                                        
                                        $sales_total_qty[] = $item_qty;
                                        $sales_total_amount[] = $item_total_sale_price;
                                        $sales_total_discount[] = $item_discount_amount;

                                        $unit_name = NULL;
                                        $item_name = NULL;
                                        $item_category = 'NULL';
                                        if(array_key_exists($inner_row['item'], $items))
                                        {
                                            $selected_item = $items[$inner_row['item']];
                                            $item_name = $selected_item['name'];
                                            $item_category = $selected_item['category'];
                                            if($inner_row['unit'] == 'purchase')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['purchase_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL;
                                            }
                                            if($inner_row['unit'] == 'sale')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['sale_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL;
                                            }
                                            if($inner_row['unit'] == 'production')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['production_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL;
                                            }
                                        }
                                        $sales_total[] = $item_total_amount;
                                    ?>

                                        <tr class="text-center">
                                            <td><?= $i++; ?></td>
                                            <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                            <td><a target="_blank" href="<?= url('sales/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                            <td><?= $item_name; ?></td>
                                            <td><?= array_key_exists($item_category, $product_categories) ? $product_categories[$item_category]['name'] : NULL; ?></td>
                                            <td><?= round_decimels_digits($item_sale_price); ?></td>
                                            <td><?= round_decimels_digits($item_qty); ?></td>
                                            <td><?= round_decimels_digits($item_total_sale_price); ?></td>
                                            <td><?= round_decimels_digits($item_discount_amount); ?></td>
                                            <td><?= $unit_name; ?></td>
                                        </tr>

                                    <?php } ?>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($sales_total_qty)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($sales_total_amount)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($sales_total_discount)); ?></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>