<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'damage_items_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'damage_items_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">

    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'damage_items_report'); ?></h2>

                    <form id="damage-items-report-search-form" action="<?= url('/reports/damage-items'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="warehouse">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_warehouse'); ?> --</option>
                                                <?php foreach($warehouse as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_warehouse == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'narration'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $total_qty = array(); $i = 1; foreach($pageData as $row){ ?>
                                    <?php
                                        $unit_name = NULL;
                                        $item_name = NULL;
                                        if(array_key_exists($row['item'], $items))
                                        {
                                            $selected_item = $items[$row['item']];
                                            $item_name = $selected_item['name'];
                                            if($row['unit'] == 'purchase')
                                            {
                                                $unit_name = array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL;
                                            }
                                            if($row['unit'] == 'sale')
                                            {
                                                $unit_name = array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL;
                                            }
                                            if($row['unit'] == 'production')
                                            {
                                                $unit_name = array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL;
                                            }
                                        }
                                    ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $item_name; ?></td>
                                        <td><?= array_key_exists($row['warehouse'], $warehouse) ? $warehouse[$row['warehouse']]['name'] : NULL; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?= $row['qty']; $total_qty[] = $row['qty']; ?></td>
                                        <td><?= $unit_name; ?></td>
                                        <td><?= $row['narration']; ?></td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td>Total</td>
                                    <td></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($total_qty)); ?></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>