<?php $item_settings = get_item_settings(); ?>

<style type="text/css">
    .print:last-child {
         page-break-after: auto;
    }
    @media print {html,body{height: 99% !important; padding: 5px;}}
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'expired_report_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'expired_report_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
        </div>
    </div>
</div>



<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'expired_report_title'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_batch'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'batch_rep_view_thead_mfg'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'batch_rep_view_thead_expiry'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tin'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tout'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_b_to_b_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_production_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_production_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_damage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_ava'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_value'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $opening_units_total = [];
                                $purchase_units_total = [];
                                $production_in_units_total = [];
                                $production_out_units_total = [];
                                $sale_units_total = [];
                                $sale_return_units_total = [];
                                $branch_to_branch_transfer_in_units_total = [];
                                $branch_to_branch_transfer_out_units_total = [];
                                $damage_units_total = [];
                                $expenses_deductions_units_total = [];
                                $transfer_in_pharma_total = [];
                                $transfer_out_pharma_total = [];
                                $transfer_in_units_total = [];
                                $transfer_out_units_total = [];
                                $branch_transfer_in_units_total = [];
                                $branch_transfer_out_units_total = [];
                                $available_units_total = [];
                                $available_units_amount_total = [];
                                $avg_cost_total = [];
                                $last_cost_total = [];
                                $first_cost_total = [];
                                $sales_price_total = [];
                                $i = 1;
                                
                                foreach($item_inventory_query as $row){
                                    // get batch wise item last mfg and expiry dates
                                    $mfg = null;
                                    $expiry = null;
                                    $module = 'items';
                                    $mfg_query = DB::table('items_inventory_stats')->where('item',$row['item'])->where(function($query) use ($module){ 
                                        $query->where('module_name','items');
                                        $query->orWhere('module_name','purchases'); 
                                        $query->orWhere('module_name','branch_transfer_in'); 
                                        $query->orWhere('module_name','transfer_in'); 
                                        $query->orWhere('module_name','production_in'); 
                                        $query->orWhere('module_name','branch_to_branch_transfer_in'); 
                                    });
                                    $mfg_query = std_obj_to_array($mfg_query->whereNotNull('mfg')->orderBy('event_date','desc')->get()->first());
                                    if(!empty($mfg_query)){ $mfg = $mfg_query['mfg']; }

                                    $expiry_query = DB::table('items_inventory_stats')->where('item',$row['item'])->where(function($query) use ($module){ 
                                        $query->where('module_name','items');
                                        $query->orWhere('module_name','purchases'); 
                                        $query->orWhere('module_name','branch_transfer_in'); 
                                        $query->orWhere('module_name','transfer_in'); 
                                        $query->orWhere('module_name','production_in'); 
                                        $query->orWhere('module_name','branch_to_branch_transfer_in'); 
                                    });
                                    $expiry_query = std_obj_to_array($expiry_query->whereNotNull('expiry')->orderBy('event_date','desc')->get()->first());
                                    if(!empty($expiry_query)){ $expiry = $expiry_query['expiry']; }
                                    // get batch wise item last mfg and expiry dates

                                    $item_db_record = array_key_exists($row['item'], $items) ? $items[$row['item']] : NULL;
                                    $item_db_record_stats = json_decode($item_db_record['stats'],true);
                                    $item_avg_cost = (float)$item_db_record_stats['avg_cost'];
                                    $item_first_cost = (float)$item_db_record['cost'];
                                    $item_last_cost = (float)$item_db_record_stats['last_cost'];
                                    $item_sale_price = (float)$item_db_record_stats['avg_cost'] + (float)$item_db_record_stats['last_profit'];


                                    $opening_units = (float)$row['opening_units'];
                                    $purchase_units_in = (float)$row['purchase_units'];
                                    $purchase_bonus_in = (float)$row['purchase_bonus_units'];
                                    $purchase_units = $purchase_units_in + $purchase_bonus_in + $opening_units;

                                    $production_in_units = (float)$row['production_in_units'];
                                    $production_out_units = (float)$row['production_out_units'];

                                    $sale_units_in = (float)$row['sale_units'];
                                    $sale_bonus_in = (float)$row['sale_bonus_units'];
                                    $sale_units = $sale_units_in + $sale_bonus_in;

                                    $sale_return_units_in = (float)$row['sale_return_units'];
                                    $sale_return_bonus_in = (float)$row['sale_return_bonus_units'];
                                    $sale_return_units = $sale_return_units_in + $sale_return_bonus_in;

                                    $branch_to_branch_transfer_in_units = (float)$row['branch_to_branch_transfer_in_units'];
                                    $branch_to_branch_transfer_out_units = (float)$row['branch_to_branch_transfer_out_units'];

                                    $damage_units = (float)$row['damage_units'];

                                    $expenses_deductions_units = (float)$row['expenses_deductions_units'];

                                    $transfer_in_pharma_units = (float)$row['transfer_in_pharma'];
                                    $transfer_in_pharma_bonus = (float)$row['transfer_in_pharma_bonus'];
                                    $transfer_in_pharma = $transfer_in_pharma_units + $transfer_in_pharma_bonus;

                                    $transfer_out_pharma_units = (float)$row['transfer_out_pharma'];
                                    $transfer_out_pharma_bonus = (float)$row['transfer_out_pharma_bonus'];
                                    $transfer_out_pharma = $transfer_out_pharma_units + $transfer_out_pharma_bonus;

                                    $transfer_in_units = (float)$row['transfer_in_units'];
                                    $transfer_out_units = (float)$row['transfer_out_units'];

                                    $branch_transfer_in_units = (float)$row['branch_transfer_in_units'];
                                    $branch_transfer_out_units = (float)$row['branch_transfer_out_units'];

                                    $stock_in_units = $purchase_units + $production_in_units + $sale_return_units + $branch_to_branch_transfer_in_units + $transfer_in_pharma + $branch_transfer_in_units + $transfer_in_units;
                                    $stock_out_units = $production_out_units + $sale_units + $branch_to_branch_transfer_out_units + $damage_units + $expenses_deductions_units + $transfer_out_pharma + $transfer_out_units + $branch_transfer_out_units;
                                    $available_units = $stock_in_units - $stock_out_units;

                                    $unit = array_key_exists($item_db_record['purchase_unit'], $units) ? $units[$item_db_record['purchase_unit']]['short'] : NULL;
                                    // check for expiry alert... if expiry date and expiry alert is not empty
                                    if(!empty($expiry) AND !empty($item_db_record['expiry_alert']))
                                    {
                                        $today = date('Y-m-d');
                                        $today = new DateTime($today);
                                        $expiry_date_batch = new DateTime($mfg);
                                        // if expiry date is passed than it will not include in near expiry stock
                                        if($today > $expiry_date_batch){                                    
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= $unit; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?php if(!empty($mfg)){echo display_true_date($mfg);}; ?></td>
                                        <td><?php if(!empty($expiry)){echo display_true_date($expiry);}; ?></td>
                                        <td><?= amount_number_format($purchase_units); $purchase_units_total[] = $purchase_units; ?></td>
                                        <td><?= amount_number_format($sale_units); $sale_units_total[] = $sale_units ?></td>
                                        <td><?= amount_number_format($sale_return_units); $sale_return_units_total[] = $sale_return_units ?></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= amount_number_format($branch_transfer_in_units); $branch_transfer_in_units_total[] = $branch_transfer_in_units ?></td>
                                            <td><?= amount_number_format($branch_transfer_out_units); $branch_transfer_out_units_total[] = $branch_transfer_out_units ?></td>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= amount_number_format($transfer_in_pharma); $transfer_in_pharma_total[] = $transfer_in_pharma ?></td>
                                            <td><?= amount_number_format($transfer_out_pharma); $transfer_out_pharma_total[] = $transfer_out_pharma ?></td>
                                        <?php } ?>

                                        <td><?= amount_number_format($branch_to_branch_transfer_in_units); $branch_to_branch_transfer_in_units_total[] = $branch_to_branch_transfer_in_units ?></td>
                                        <td><?= amount_number_format($branch_to_branch_transfer_out_units); $branch_to_branch_transfer_out_units_total[] = $branch_to_branch_transfer_out_units ?></td>
                                        <td><?= amount_number_format($production_in_units); $production_in_units_total[] = $production_in_units ?></td>
                                        <td><?= amount_number_format($production_out_units); $production_out_units_total[] = $production_out_units ?></td>
                                        <td><?= amount_number_format($damage_units); $damage_units_total[] = $damage_units ?></td>
                                        <td><?= amount_number_format($available_units); $available_units_total[] = $available_units ?></td>
                                        <td><?= amount_number_format($item_sale_price); $sales_price_total[] = $item_sale_price ?></td>
                                        <td><?= amount_number_format($available_units * $item_sale_price); $available_units_amount_total[] = $available_units * $item_sale_price; ?></td>
                                    </tr>
                                <?php }}} ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= amount_number_format(array_sum($purchase_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($sale_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($sale_return_units_total)); ?></strong></td>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <td><strong><?= amount_number_format(array_sum($branch_transfer_in_units_total)); ?></strong></td>
                                        <td><strong><?= amount_number_format(array_sum($branch_transfer_out_units_total)); ?></strong></td>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <td><strong><?= amount_number_format(array_sum($transfer_in_pharma_total)); ?></strong></td>
                                        <td><strong><?= amount_number_format(array_sum($transfer_out_pharma_total)); ?></strong></td>
                                    <?php } ?>
                                    <td><strong><?= amount_number_format(array_sum($branch_to_branch_transfer_in_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($branch_to_branch_transfer_out_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($production_in_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($production_out_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($damage_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($available_units_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($sales_price_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($available_units_amount_total)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>