<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_financial_accounts_ledger_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_financial_accounts_ledger_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_financial_accounts_ledger_view_heading'); ?></h2>
                    
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width:50px; max-width:50px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'name'); ?></th>
                                    <?php foreach($currencies as $row){?>
                                        <th class="text-center"><?= $row['name']; ?></th>
                                    <?php } ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">                    
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <?php foreach($currencies as $crow){?>
                                            <td>
                                                <a target="_blank" style="color: #000 !important;" href="<?= url('/reports/accounts').'?type='.$row['type'].'&currency='.$crow['uid'].'&account='.$row['uid'].''; ?>">
                                                    <?= amount_number_format(get_account_balance($row['uid'],$crow['uid'])); ?>
                                                </a>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>