<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'inventory'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'inventory'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'inventory_report'); ?></h2>

                    <form id="inventory-report-search-form" action="<?= url('/reports/inventory'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="category">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'category'); ?> --</option>
                                            <?php foreach($product_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_category == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="tpcp">
                                            <option value="cp" <?php if($search_tpcp == 'cp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cp'); ?></option>
                                            <option value="tp" <?php if($search_tpcp == 'tp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'tp'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3" style="padding: 2px;">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="padding: 2px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'opening'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'purchased'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'branch_transfer_in_short'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'ph_transfer_in_short'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'total_stock'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'gross_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'damage'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'branch_transfer_out_short'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'ph_transfer_out_short'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'closing'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $opening_units_total = [];
                                    $opening_units_amount_total = [];
                                    $purchase_units_total = [];
                                    $purchase_units_amount_total = [];
                                    $production_in_units_total = [];
                                    $production_in_units_amount_total = [];
                                    $production_out_units_total = [];
                                    $production_out_units_amount_total = [];
                                    $sale_units_total = [];
                                    $sale_units_amount_total = [];
                                    $sale_return_units_total = [];
                                    $sale_return_units_amount_total = [];
                                    $branch_to_branch_transfer_in_units_total = [];
                                    $branch_to_branch_transfer_in_units_amount_total = [];
                                    $branch_to_branch_transfer_out_units_total = [];
                                    $branch_to_branch_transfer_out_units_amount_total = [];
                                    $damage_units_total = [];
                                    $damage_units_amount_total = [];
                                    $expenses_deductions_units_total = [];
                                    $expenses_deductions_units_amount_total = [];
                                    $transfer_in_pharma_total = [];
                                    $transfer_in_pharma_amount_total = [];
                                    $transfer_out_pharma_total = [];
                                    $transfer_out_pharma_amount_total = [];
                                    $transfer_in_units_total = [];
                                    $transfer_in_units_amount_total = [];
                                    $transfer_out_units_total = [];
                                    $transfer_out_units_amount_total = [];
                                    $branch_transfer_in_units_total = [];
                                    $branch_transfer_in_units_amount_total = [];
                                    $branch_transfer_out_units_total = [];
                                    $branch_transfer_out_units_amount_total = [];
                                    $total_stock_in_total = [];
                                    $total_stock_in_amount_total = [];
                                    $total_stock_out_total = [];
                                    $total_stock_out_amount_total = [];
                                    $total_ava_units_total = [];
                                    $total_ava_units_amount_total = [];
                                    $total_stock_units_total = [];
                                    $total_stock_units_amount_total = [];
                                    $gross_sales_units_total = [];
                                    $gross_sales_units_amount_total = [];

                                    $empty_inventory = [
                                        'opening_units' => 0,
                                        'purchase_units' => 0,
                                        'purchase_bonus_units' => 0,
                                        'production_in_units' => 0,
                                        'production_out_units' => 0,
                                        'sale_units' => 0,
                                        'sale_bonus_units' => 0,
                                        'sale_return_units' => 0,
                                        'sale_return_bonus_units' => 0,
                                        'branch_to_branch_transfer_in_units' => 0,
                                        'branch_to_branch_transfer_out_units' => 0,
                                        'damage_units' => 0,
                                        'expenses_deductions_units' => 0,
                                        'transfer_in_pharma' => 0,
                                        'transfer_in_pharma_bonus' => 0,
                                        'transfer_out_pharma' => 0,
                                        'transfer_out_pharma_bonus' => 0,
                                        'transfer_in_units' => 0,
                                        'transfer_out_units' => 0,
                                        'branch_transfer_in_units' => 0,
                                        'branch_transfer_out_units' => 0,
                                        'total_stock_in' => 0,
                                        'total_stock_out' => 0,
                                    ];

                                    $i = 1; foreach($items as $item){
                                    $item_db_record = $item;
                                    $item_db_record_stats = json_decode($item_db_record['stats'],true);
                                    $item_avg_cost = (float)$item_db_record_stats['avg_cost'];
                                    $item_sale_price = (float)$item_db_record_stats['avg_cost'] + (float)$item_db_record_stats['last_profit'];
                                    $rate_to_calculate = $item_avg_cost;
                                    $row = isset($item_inventory_query[$item['uid']]) ? $item_inventory_query[$item['uid']] : $empty_inventory;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $item['name']; ?></td>
                                        <td><span class="text-info font-bold"><?= array_key_exists($item_db_record['purchase_unit'], $units) ? $units[$item_db_record['purchase_unit']]['short'] : NULL; ?></span></td>
                                        
                                        <?php
                                        $currency_symbol = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['symbol'] : NULL;
                                        if($search_tpcp == 'tp')
                                        {
                                            $rate_to_calculate = $item_sale_price;
                                        }
                                        if(!empty($search_currency))
                                        {
                                            $rate_to_calculate = amount_conversion($rate_to_calculate, $item_db_record['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        $before_filter_in_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_stock_in'] : 0;
                                        $before_filter_in_bonus_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_bonus_in'] : 0;
                                        $before_filter_out_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_stock_out'] : 0;
                                        $before_filter_out_bonus_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_bonus_out'] : 0;
                                        $before_filter_ava_units = $before_filter_in_units + $before_filter_in_bonus_units - $before_filter_out_units - $before_filter_out_bonus_units;

                                        $opening_units = (float)$row['opening_units'] + $before_filter_ava_units; $opening_units_total[] = $opening_units;
                                        $opening_units_amount = ((float)$row['opening_units'] + $before_filter_ava_units) * $rate_to_calculate; $opening_units_amount_total[] = $opening_units_amount;

                                        $purchase_units_in = (float)$row['purchase_units'];
                                        $purchase_bonus_in = (float)$row['purchase_bonus_units'];

                                        $purchase_units = $purchase_units_in + $purchase_bonus_in; $purchase_units_total[] = $purchase_units;
                                        $purchase_units_amount = $purchase_units * $rate_to_calculate; $purchase_units_amount_total[] = $purchase_units_amount;

                                        $production_in_units = (float)$row['production_in_units']; $production_in_units_total[] = $production_in_units;
                                        $production_in_units_amount = (float)$row['production_in_units'] * $rate_to_calculate; $production_in_units_amount_total[] = $production_in_units_amount;

                                        $production_out_units = (float)$row['production_out_units']; $production_out_units_total[] = $production_out_units;
                                        $production_out_units_amount = (float)$row['production_out_units'] * $rate_to_calculate; $production_out_units_amount_total[] = $production_out_units_amount;

                                        $sale_units_in = (float)$row['sale_units'];
                                        $sale_bonus_in = (float)$row['sale_bonus_units'];

                                        $sale_units = $sale_units_in + $sale_bonus_in; $sale_units_total[] = $sale_units;
                                        $sale_units_amount = $sale_units * $rate_to_calculate; $sale_units_amount_total[] = $sale_units_amount;

                                        $sale_return_units_in = (float)$row['sale_return_units'];
                                        $sale_return_bonus_in = (float)$row['sale_return_bonus_units'];

                                        $sale_return_units = $sale_return_units_in + $sale_return_bonus_in; $sale_return_units_total[] = $sale_return_units;
                                        $sale_return_units_amount = $sale_return_units * $rate_to_calculate; $sale_return_units_amount_total[] = $sale_return_units_amount;

                                        $branch_to_branch_transfer_in_units = (float)$row['branch_to_branch_transfer_in_units']; $branch_to_branch_transfer_in_units_total[] = $branch_to_branch_transfer_in_units;
                                        $branch_to_branch_transfer_in_units_amount = (float)$row['branch_to_branch_transfer_in_units'] * $rate_to_calculate; $branch_to_branch_transfer_in_units_amount_total[] = $branch_to_branch_transfer_in_units_amount;

                                        $branch_to_branch_transfer_out_units = (float)$row['branch_to_branch_transfer_out_units']; $branch_to_branch_transfer_out_units_total[] = $branch_to_branch_transfer_out_units;
                                        $branch_to_branch_transfer_out_units_amount = (float)$row['branch_to_branch_transfer_out_units'] * $rate_to_calculate; $branch_to_branch_transfer_out_units_amount_total[] = $branch_to_branch_transfer_out_units_amount;

                                        $damage_units = (float)$row['damage_units']; $damage_units_total[] = $damage_units;
                                        $damage_units_amount = (float)$row['damage_units'] * $rate_to_calculate; $damage_units_amount_total[] = $damage_units_amount;

                                        $expenses_deductions_units = (float)$row['expenses_deductions_units']; $expenses_deductions_units_total[] = $expenses_deductions_units;
                                        $expenses_deductions_units_amount = (float)$row['expenses_deductions_units'] * $rate_to_calculate; $expenses_deductions_units_amount_total[] = $expenses_deductions_units_amount;

                                        $transfer_in_pharma_units = (float)$row['transfer_in_pharma'];
                                        $transfer_in_pharma_bonus = (float)$row['transfer_in_pharma_bonus'];

                                        $transfer_in_pharma = $transfer_in_pharma_units + $transfer_in_pharma_bonus; $transfer_in_pharma_total[] = $transfer_in_pharma;
                                        $transfer_in_pharma_amount = $transfer_in_pharma * $rate_to_calculate; $transfer_in_pharma_amount_total[] = $transfer_in_pharma_amount;

                                        $transfer_out_pharma_units = (float)$row['transfer_out_pharma'];
                                        $transfer_out_pharma_bonus = (float)$row['transfer_out_pharma_bonus'];

                                        $transfer_out_pharma = $transfer_out_pharma_units + $transfer_out_pharma_bonus; $transfer_out_pharma_total[] = $transfer_out_pharma;
                                        $transfer_out_pharma_amount = $transfer_out_pharma * $rate_to_calculate; $transfer_out_pharma_amount_total[] = $transfer_out_pharma_amount;

                                        $transfer_in_units = (float)$row['transfer_in_units']; $transfer_in_units_total[] = $transfer_in_units;
                                        $transfer_in_units_amount = (float)$row['transfer_in_units'] * $rate_to_calculate; $transfer_in_units_amount_total[] = $transfer_in_units_amount;

                                        $transfer_out_units = (float)$row['transfer_out_units']; $transfer_out_units_total[] = $transfer_out_units;
                                        $transfer_out_units_amount = (float)$row['transfer_out_units'] * $rate_to_calculate; $transfer_out_units_amount_total[] = $transfer_out_units_amount;

                                        $branch_transfer_in_units = (float)$row['branch_transfer_in_units']; $branch_transfer_in_units_total[] = $branch_transfer_in_units;
                                        $branch_transfer_in_units_amount = (float)$row['branch_transfer_in_units'] * $rate_to_calculate; $branch_transfer_in_units_amount_total[] = $branch_transfer_in_units_amount;

                                        $branch_transfer_out_units = (float)$row['branch_transfer_out_units']; $branch_transfer_out_units_total[] = $branch_transfer_out_units;
                                        $branch_transfer_out_units_amount = (float)$row['branch_transfer_out_units'] * $rate_to_calculate; $branch_transfer_out_units_amount_total[] = $branch_transfer_out_units_amount;

                                        $total_stock_in = (float)$row['total_stock_in']; $total_stock_in_total[] = $total_stock_in;
                                        $total_stock_in_amount = (float)$row['total_stock_in'] * $rate_to_calculate; $total_stock_in_amount_total[] = $total_stock_in_amount;

                                        $total_stock_out = (float)$row['total_stock_out']; $total_stock_out_total[] = $total_stock_out;
                                        $total_stock_out_amount = (float)$row['total_stock_out'] * $rate_to_calculate; $total_stock_out_amount_total[] = $total_stock_out_amount;

                                        $total_stock_in_units_calculate = $opening_units + $purchase_units + $branch_to_branch_transfer_in_units + $transfer_in_units + $branch_transfer_in_units + $sale_return_units + $production_in_units;
                                        $total_stock_out_units_calculate = $sale_units + $damage_units + $expenses_deductions_units + $branch_to_branch_transfer_out_units + $transfer_out_units + $branch_transfer_out_units + $production_out_units;

                                        $total_ava_units = $total_stock_in_units_calculate - $total_stock_out_units_calculate; $total_ava_units_total[] = $total_ava_units;
                                        $total_ava_units_amount = $total_ava_units * $rate_to_calculate; $total_ava_units_amount_total[] = $total_ava_units_amount;

                                        $total_stock_units = $opening_units + $purchase_units + $branch_transfer_in_units + $transfer_in_pharma; $total_stock_units_total[] = $total_stock_units;
                                        $total_stock_units_amount = $opening_units_amount + $purchase_units_amount + $branch_transfer_in_units_amount + $transfer_in_pharma_amount; $total_stock_units_amount_total[] = $total_stock_units_amount;

                                        $gross_sales_units = $sale_units - $sale_return_units; $gross_sales_units_total[] = $gross_sales_units;
                                        $gross_sales_units_amount = $sale_units_amount - $sale_return_units_amount; $gross_sales_units_amount_total[] = $gross_sales_units_amount;

                                        ?>

                                        <td><?= round_decimels_digits( $opening_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $opening_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $purchase_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $purchase_units_amount ); ?>)</td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_in_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $branch_transfer_in_units_amount ); ?>)</td>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $transfer_in_pharma ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $transfer_in_pharma_amount ); ?>)</td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits( $total_stock_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $total_stock_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $sale_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $sale_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $sale_return_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $sale_return_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $gross_sales_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $gross_sales_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $branch_to_branch_transfer_in_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $branch_to_branch_transfer_in_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $branch_to_branch_transfer_out_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $branch_to_branch_transfer_out_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $production_in_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $production_in_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $production_out_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $production_out_units_amount ); ?>)</td>
                                        <td><?= round_decimels_digits( $damage_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $damage_units_amount ); ?>)</td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_out_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $branch_transfer_out_units_amount ); ?>)</td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $transfer_out_pharma ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $transfer_out_pharma_amount ); ?>)</td>
                                        <?php } ?>

                                        <td><?= round_decimels_digits( $total_ava_units ); ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $total_ava_units_amount ); ?>)</td>

                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><strong></strong></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($opening_units_total) ); ?> (<?= round_decimels_digits( array_sum($opening_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($purchase_units_total) ); ?> (<?= round_decimels_digits( array_sum($purchase_units_amount_total) ); ?>)</strong></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($branch_transfer_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($branch_transfer_in_units_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($transfer_in_pharma_total) ); ?> (<?= round_decimels_digits( array_sum($transfer_in_pharma_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <td><strong><?= round_decimels_digits( array_sum($total_stock_units_total) ); ?> (<?= round_decimels_digits( array_sum($total_stock_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_units_total) ); ?> (<?= round_decimels_digits( array_sum($sale_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_return_units_total) ); ?> (<?= round_decimels_digits( array_sum($sale_return_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($gross_sales_units_total) ); ?> (<?= round_decimels_digits( array_sum($gross_sales_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($branch_to_branch_transfer_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($branch_to_branch_transfer_in_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($branch_to_branch_transfer_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($branch_to_branch_transfer_out_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($production_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($production_in_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($production_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($production_out_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($damage_units_total) ); ?> (<?= round_decimels_digits( array_sum($damage_units_amount_total) ); ?>)</strong></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($branch_transfer_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($branch_transfer_out_units_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($transfer_out_pharma_total) ); ?> (<?= round_decimels_digits( array_sum($transfer_out_pharma_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <td><strong><?= round_decimels_digits( array_sum($total_stock_units_total) ); ?> (<?= round_decimels_digits( array_sum($total_stock_units_amount_total) ); ?>)</strong></td>
                                        
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>