<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'inventory'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'inventory'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'inventory_report'); ?></h2>

                    <form id="inventory-report-search-form" action="<?= url('/reports/inventory'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="category">
                                            <option selected="" value="">-- <?= print_lang($app_lang,'category'); ?> --</option>
                                            <?php foreach($product_categories as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_category == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="tpcp">
                                            <option value="cp" <?php if($search_tpcp == 'cp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'cp'); ?></option>
                                            <option value="tp" <?php if($search_tpcp == 'tp'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'tp'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <div>
                                            <select data-placeholder="<?= print_lang($app_lang,'marketer'); ?>" name="marketer" class="chosen-select" multiple tabindex="4">
                                                
                                                <?php foreach($marketers as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if(in_array($row['uid'], $search_marketer)){ echo 'selected="selected"'; } ?>  ><?= $row['name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="padding: 2px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'opening'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'purchased'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'branch_transfer_in_short'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'ph_transfer_in_short'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'total_stock'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'gross_sales'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mode_production_thead_title_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'damage'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'branch_transfer_out_short'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'ph_transfer_out_short'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'closing'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $item_opening_units_total = array();
                                $purchase_units_total = array();
                                $branch_transfer_in_units_total = array();
                                $ph_transfer_in_units_total = array();
                                $total_stock_total = array();
                                $sale_units_total = array();
                                $sale_return_units_total = array();
                                $net_sale_units_total = array();
                                $b_to_b_in_units_total = array();
                                $b_to_b_out_units_total = array();
                                $b_to_b_in_units_amount_total = array();
                                $production_in_units_total = array();
                                $production_in_units_total = array();
                                $production_out_units_total = array();
                                $b_to_b_out_units_amount_total = array();
                                $production_in_units_amount_total = array();
                                $production_out_units_amount_total = array();
                                $damage_units_total = array();
                                $branch_transfer_out_units_total = array();
                                $ph_transfer_out_units_total = array();
                                $avail_units_total = array();
                                $item_opening_units_amount_total = array();
                                $purchase_units_amount_total = array();
                                $branch_transfer_in_units_amount_total = array();
                                $ph_transfer_in_units_amount_total = array();
                                $total_stock_amount_total = array();
                                $sale_units_amount_total = array();
                                $sale_return_units_amount_total = array();
                                $net_sale_units_amount_total = array();
                                $damage_units_amount_total = array();
                                $branch_transfer_out_units_amount_total = array();
                                $ph_transfer_out_units_amount_total = array();
                                $avail_units_amount_total = array();
                                $b_to_b_in_total = array();
                                $b_to_b_out_total = array();
                                $production_in_total = array();
                                $production_out_total = array();


                                $i = 1; foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        <td><span class="text-info font-bold"><?= array_key_exists($row['purchase_unit'], $units) ? $units[$row['purchase_unit']]['short'] : NULL; ?></span></td>
                                        
                                        <?php

                                        if(!empty($search_from))
                                        {
                                            // will have items opening stats before from date if from date set in search filter
                                            $item_opening_units = array_key_exists($row['uid'], $opening_stock_units) ? sum_up_array_values($opening_stock_units[$row['uid']]['stats']['avail_units']) : 0;
                                        }
                                        else
                                        {
                                            $item_opening_units = sum_up_array_values($row['stats']['opening_units']);
                                        }
                                        
                                        $purchase_units = sum_up_array_values($row['stats']['purchase_units']);
                                        
                                        $branch_transfer_in_units = sum_up_array_values($row['stats']['branch_transfer_in_units']);
                                        $ph_transfer_in_units = sum_up_array_values($row['stats']['transfer_in_pharma']);
                                        
                                        $total_stock = $item_opening_units + $purchase_units + $branch_transfer_in_units + $ph_transfer_in_units;;
                                        
                                        
                                        $sale_units = sum_up_array_values($row['stats']['sale_units']);
                                        $sale_return_units = sum_up_array_values($row['stats']['sale_return_units']);
                                        $branch_transfer_out_units = sum_up_array_values($row['stats']['branch_transfer_out_units']);
                                        $ph_transfer_out_units = sum_up_array_values($row['stats']['transfer_out_pharma']);
                                        $damage_units = sum_up_array_values($row['stats']['damage_units']);
                                        $b_to_b_in_units = sum_up_array_values($row['stats']['branch_to_branch_transfer_in_units']);
                                        $b_to_b_out_units = sum_up_array_values($row['stats']['branch_to_branch_transfer_out_units']);
                                        $production_in_units = sum_up_array_values($row['stats']['production_in_units']);
                                        $production_out_units = sum_up_array_values($row['stats']['production_out_units']);
                                        $net_sale_units = sum_up_array_values($row['stats']['sale_units']) - sum_up_array_values($row['stats']['sale_return_units']);
                                        $avail_units = sum_up_array_values($row['stats']['avail_units']);

                                        $item_avg_cost = $row['stats']['avg_cost'];
                                        $item_last_profit = $row['stats']['last_profit'];
                                        
                                        if(!empty($search_from))
                                        {
                                            $avail_units = $avail_units + $item_opening_units - $row['opening_stock'];
                                        }

                                        $currency_symbol = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                        if(!empty($search_currency))
                                        {
                                            $currency_symbol = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['symbol'] : NULL;
                                            $item_avg_cost = amount_conversion($item_avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_profit = amount_conversion($item_last_profit, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        if($search_tpcp == 'tp')
                                        {
                                            $batch_sale_price_last = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$row['uid'])->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->whereNotNull('sale_price')->orderBy('module_created_at','desc')->orderBy('id','desc')->get()->first());
                                            $item_avg_cost = (float)$batch_sale_price_last['sale_price'];

                                            if($batch_sale_price_last['currency'] == $row['currency'])
                                            {
                                                // no conversion
                                                $item_avg_cost = (float)$batch_sale_price_last['sale_price'];
                                            }
                                            else
                                            {
                                                // apply conversion
                                                $item_avg_cost = amount_conversion((float)$batch_sale_price_last['sale_price'], $batch_sale_price_last['currency_usd_equalance'], $row['currency_usd_equalance']);
                                            }

                                            if(!empty($search_currency))
                                            {
                                                $item_avg_cost = amount_conversion($item_avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            }
                                            // $item_avg_cost = $item_avg_cost + $item_last_profit;
                                        }
                                        $item_avg_cost = round_decimels_digits($item_avg_cost);

                                        $item_opening_units_amount = $item_opening_units * $item_avg_cost;
                                        $purchase_units_amount = $purchase_units * $item_avg_cost;
                                        $branch_transfer_in_units_amount = $branch_transfer_in_units * $item_avg_cost;
                                        $ph_transfer_in_units_amount = $ph_transfer_in_units * $item_avg_cost;
                                        $total_stock_amount = $total_stock * $item_avg_cost;
                                        $sale_units_amount = $sale_units * $item_avg_cost;
                                        $sale_return_units_amount = $sale_return_units * $item_avg_cost;
                                        $net_sale_units_amount = $net_sale_units * $item_avg_cost;
                                        $branch_transfer_out_units_amount = $branch_transfer_out_units * $item_avg_cost;
                                        $ph_transfer_out_units_amount = $ph_transfer_out_units * $item_avg_cost;
                                        $b_to_b_in_units_amount = $b_to_b_in_units * $item_avg_cost;
                                        $b_to_b_out_units_amount = $b_to_b_out_units * $item_avg_cost;
                                        $production_in_units_amount = $production_in_units * $item_avg_cost;
                                        $production_out_units_amount = $production_out_units * $item_avg_cost;
                                        $damage_units_amount = $damage_units * $item_avg_cost;
                                        $avail_units_amount = $avail_units * $item_avg_cost;

                                        ?>

                                        <td><?= round_decimels_digits( $item_opening_units ); $item_opening_units_total[] = $item_opening_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $item_opening_units_amount ); $item_opening_units_amount_total[] = $item_opening_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $purchase_units ); $purchase_units_total[] = $purchase_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $purchase_units_amount ); $purchase_units_amount_total[] = $purchase_units_amount; ?>)</td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_in_units ); $branch_transfer_in_units_total[] = $branch_transfer_in_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $branch_transfer_in_units_amount ); $branch_transfer_in_units_amount_total[] = $branch_transfer_in_units_amount; ?>)</td>
                                        <?php } ?>

                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $ph_transfer_in_units ); $ph_transfer_in_units_total[] = $ph_transfer_in_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $ph_transfer_in_units_amount ); $ph_transfer_in_units_amount_total[] = $ph_transfer_in_units_amount; ?>)</td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits( $total_stock ); $total_stock_total[] = $total_stock; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $total_stock_amount ); $total_stock_amount_total[] = $total_stock_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $sale_units ); $sale_units_total[] = $sale_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $sale_units_amount ); $sale_units_amount_total[] = $sale_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $sale_return_units ); $sale_return_units_total[] = $sale_return_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $sale_return_units_amount ); $sale_return_units_amount_total[] = $sale_return_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $net_sale_units ); $net_sale_units_total[] = $net_sale_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $net_sale_units_amount ); $net_sale_units_amount_total[] = $net_sale_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $b_to_b_in_units ); $b_to_b_in_units_total[] = $b_to_b_in_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $b_to_b_in_units_amount ); $b_to_b_in_units_amount_total[] = $b_to_b_in_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $b_to_b_out_units ); $b_to_b_out_units_total[] = $b_to_b_out_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $b_to_b_out_units_amount ); $b_to_b_out_units_amount_total[] = $b_to_b_out_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $production_in_units ); $production_in_units_total[] = $production_in_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $production_in_units_amount ); $production_in_units_amount_total[] = $production_in_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $production_out_units ); $production_out_units_total[] = $production_out_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $production_out_units_amount ); $production_out_units_amount_total[] = $production_out_units_amount; ?>)</td>
                                        <td><?= round_decimels_digits( $damage_units ); $damage_units_total[] = $damage_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $damage_units_amount ); $damage_units_amount_total[] = $damage_units_amount; ?>)</td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_out_units ); $branch_transfer_out_units_total[] = $branch_transfer_out_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $branch_transfer_out_units_amount ); $branch_transfer_out_units_amount_total[] = $branch_transfer_out_units_amount; ?>)</td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $ph_transfer_out_units ); $ph_transfer_out_units_total[] = $ph_transfer_out_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $ph_transfer_out_units_amount ); $ph_transfer_out_units_amount_total[] = $ph_transfer_out_units_amount; ?>)</td>
                                        <?php } ?>

                                        <td><?= round_decimels_digits( $avail_units ); $avail_units_total[] = $avail_units; ?> (<?= $currency_symbol; ?><?= round_decimels_digits( $avail_units_amount ); $avail_units_amount_total[] = $avail_units_amount; ?>)</td>

                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><strong></strong></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td><strong></strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($item_opening_units_total) ); ?> (<?= round_decimels_digits( array_sum($item_opening_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($purchase_units_total) ); ?> (<?= round_decimels_digits( array_sum($purchase_units_amount_total) ); ?>)</strong></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($branch_transfer_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($branch_transfer_in_units_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($ph_transfer_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($ph_transfer_in_units_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <td><strong><?= round_decimels_digits( array_sum($total_stock_total) ); ?> (<?= round_decimels_digits( array_sum($total_stock_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_units_total) ); ?> (<?= round_decimels_digits( array_sum($sale_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($sale_return_units_total) ); ?> (<?= round_decimels_digits( array_sum($sale_return_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($net_sale_units_total) ); ?> (<?= round_decimels_digits( array_sum($net_sale_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($b_to_b_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($b_to_b_in_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($b_to_b_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($b_to_b_out_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($production_in_units_total) ); ?> (<?= round_decimels_digits( array_sum($production_in_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($production_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($production_out_units_amount_total) ); ?>)</strong></td>
                                        <td><strong><?= round_decimels_digits( array_sum($damage_units_total) ); ?> (<?= round_decimels_digits( array_sum($damage_units_amount_total) ); ?>)</strong></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($branch_transfer_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($branch_transfer_out_units_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><strong><?= round_decimels_digits( array_sum($ph_transfer_out_units_total) ); ?> (<?= round_decimels_digits( array_sum($ph_transfer_out_units_amount_total) ); ?>)</strong></td>
                                        <?php } ?>
                                        <td><strong><?= round_decimels_digits( array_sum($avail_units_total) ); ?> (<?= round_decimels_digits( array_sum($avail_units_amount_total) ); ?>)</strong></td>
                                        
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>