<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_item_stock_rep_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_item_stock_rep_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_item_stock_rep_title'); ?></h2>

                    <form id="item-stock-report-search-form" action="<?= url('/reports/item-stock'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'mod_item_stock_rep_filter_item'); ?></label>
                                        <select class="form-control chosen-select" name="item">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'mod_item_stock_rep_filter_item'); ?> --</option>
                                            <?php foreach($items as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'mod_item_stock_rep_filter_source'); ?></label>
                                        <select class="form-control chosen-select" name="source">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'mod_item_stock_rep_filter_source'); ?> --</option>
                                            <option value="purchases" <?php if($search_source == 'purchases'){ echo "selected='selected'";}?>><?= print_lang($app_lang,'mod_item_stock_rep_filter_source_purchases'); ?></option>
                                            <option value="sales" <?php if($search_source == 'sales'){ echo "selected='selected'";}?>><?= print_lang($app_lang,'mod_item_stock_rep_filter_source_sales'); ?></option>
                                            <option value="sales_return" <?php if($search_source == 'sales_return'){ echo "selected='selected'";}?>><?= print_lang($app_lang,'mod_item_stock_rep_filter_source_sales_return'); ?></option>
                                            <option value="transfer_in" <?php if($search_source == 'transfer_in'){ echo "selected='selected'";}?>><?= print_lang($app_lang,'mod_item_stock_rep_filter_source_transfer_in'); ?></option>
                                            <option value="transfer_out" <?php if($search_source == 'transfer_out'){ echo "selected='selected'";}?>><?= print_lang($app_lang,'mod_item_stock_rep_filter_source_transfer_out'); ?></option>
                                            <option value="damage" <?php if($search_source == 'damage'){ echo "selected='selected'";}?>><?= print_lang($app_lang,'mod_item_stock_rep_filter_source_damage'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <?php
                            if(!empty($item_data)){ ?>
                                <h2><?= ucfirst($item_data['name']); ?></h2>
                            <?php } ?>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_source'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_batch'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_stock_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_item_stock_rep_stock_out'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $i = 1; 
                                if(!empty($item_data)){
                                foreach($pageData['records'] as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['date']); ?></td>
                                        <td><?= $row['narration']; ?></td>
                                        <td><?= $row['account_name']; ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?= $row['stock_in']; ?></td>
                                        <td><?= $row['stock_out']; ?></td>
                                    </tr>
                                <?php }} ?>
                                <?php if(!empty($item_data)){?>
                                    <tr class="text-center">
                                        <td></td>
                                        <td></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td><strong><?= array_sum($pageData['stock_in']); ?></strong></td>
                                        <td><strong><?= array_sum($pageData['stock_out']); ?></strong></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="font-size: 18px !important;"><?= print_lang($app_lang,'mod_item_stock_rep_currency_total'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                if(!empty($item_data)){ ?>
                                    <tr>
                                        <td style="font-size: 15px !important;">
                                            <strong style="display: block; float: left; width: 200px;"><?= print_lang($app_lang,'mod_item_stock_rep_purchased_total'); ?>:</strong>&nbsp;&nbsp;
                                            <span style="color: #010f42 !important;">
                                                <?php 
                                                    foreach($currencies as $row)
                                                    {
                                                        if(isset($pageData['purchase_totals']))
                                                        {
                                                            if(array_key_exists($row['uid'], $pageData['purchase_totals']))
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  '.array_sum($pageData['purchase_totals'][$row['uid']]).'</span>';
                                                            }
                                                            else
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                            }
                                                        }
                                                        else
                                                        {
                                                            echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                        }
                                                    }
                                                ?>
                                            </span>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td style="font-size: 15px !important;">
                                            <strong style="display: block; float: left; width: 200px;"><?= print_lang($app_lang,'mod_item_stock_rep_sales_total'); ?>:</strong>&nbsp;&nbsp;
                                            <span style="color: #010f42 !important;">
                                                <?php 
                                                    foreach($currencies as $row)
                                                    {
                                                        if(isset($pageData['sales_totals']))
                                                        {
                                                            if(array_key_exists($row['uid'], $pageData['sales_totals']))
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  '.array_sum($pageData['sales_totals'][$row['uid']]).'</span>';
                                                            }
                                                            else
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                            }
                                                        }
                                                        else
                                                        {
                                                            echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                        }
                                                    }
                                                ?>
                                            </span>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td style="font-size: 15px !important;">
                                            <strong style="display: block; float: left; width: 200px;"><?= print_lang($app_lang,'mod_item_stock_rep_sales_ret_total'); ?>:</strong>&nbsp;&nbsp;
                                            <span style="color: #010f42 !important;">
                                                <?php 
                                                    foreach($currencies as $row)
                                                    {
                                                        if(isset($pageData['sales_return_totals']))
                                                        {
                                                            if(array_key_exists($row['uid'], $pageData['sales_return_totals']))
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  '.array_sum($pageData['sales_return_totals'][$row['uid']]).'</span>';
                                                            }
                                                            else
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                            }
                                                        }
                                                        else
                                                        {
                                                            echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                        }
                                                    }
                                                ?>
                                            </span>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td style="font-size: 15px !important;">
                                            <strong style="display: block; float: left; width: 200px;"><?= print_lang($app_lang,'mod_item_stock_rep_trans_in_total'); ?>:</strong>&nbsp;&nbsp;
                                            <span style="color: #010f42 !important;">
                                                <?php 
                                                    foreach($currencies as $row)
                                                    {
                                                        if(isset($pageData['transfer_in_totals']))
                                                        {
                                                            if(array_key_exists($row['uid'], $pageData['transfer_in_totals']))
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  '.array_sum($pageData['transfer_in_totals'][$row['uid']]).'</span>';
                                                            }
                                                            else
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                            }
                                                        }
                                                        else
                                                        {
                                                            echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                        }
                                                    }
                                                ?>
                                            </span>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td style="font-size: 15px !important;">
                                            <strong style="display: block; float: left; width: 200px;"><?= print_lang($app_lang,'mod_item_stock_rep_trans_out_total'); ?>:</strong>&nbsp;&nbsp;
                                            <span style="color: #010f42 !important;">
                                                <?php 
                                                    foreach($currencies as $row)
                                                    {
                                                        if(isset($pageData['transfer_out_totals']))
                                                        {
                                                            if(array_key_exists($row['uid'], $pageData['transfer_out_totals']))
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  '.array_sum($pageData['transfer_out_totals'][$row['uid']]).'</span>';
                                                            }
                                                            else
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                            }
                                                        }
                                                        else
                                                        {
                                                            echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                        }
                                                    }
                                                ?>
                                            </span>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td style="font-size: 15px !important;">
                                            <strong style="display: block; float: left; width: 200px;"><?= print_lang($app_lang,'mod_item_stock_rep_damage_total'); ?>:</strong>&nbsp;&nbsp;
                                            <span style="color: #010f42 !important;">
                                                <?php 
                                                    foreach($currencies as $row)
                                                    {
                                                        if(isset($pageData['damage_totals']))
                                                        {
                                                            if(array_key_exists($row['uid'], $pageData['damage_totals']))
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  '.array_sum($pageData['damage_totals'][$row['uid']]).'</span>';
                                                            }
                                                            else
                                                            {
                                                                echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                            }
                                                        }
                                                        else
                                                        {
                                                            echo '<span style="display: block; float: left; min-width: 130px;">'.ucfirst($row['symbol']).'  0 </span>';
                                                        }
                                                    }
                                                ?>
                                            </span>
                                        </td>
                                    </tr>                                  
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>