<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'items_by_warehouse_report_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'items_by_warehouse_report_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <form id="items-by-warehouse-report-search-form" action="<?= url('/reports/items-by-warehouse'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'items_by_warehouse_report_filter_unit'); ?></label>
                                        <select class="form-control chosen-select" name="unit">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'items_by_warehouse_report_filter_unit_placehlder'); ?> --</option>
                                            <?php foreach($units as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_unit == $row['uid']){ echo 'selected="selected"'; } ?>  ><?= $row['name'].' ('.$row['short'].')'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'items_by_warehouse_report_view_title'); ?></h2>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'items_by_warehouse_report_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_by_warehouse_report_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_by_warehouse_report_thead_country'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_by_warehouse_report_thead_company'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_by_warehouse_report_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_by_warehouse_report_thead_qty_unit'); ?></th>
                                    <?php foreach($warehouses as $row){?>
                                        <th class="text-center"><?= ucfirst($row['name']); ?></th>
                                    <?php } ?>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $i = 1;
                                foreach($items as $row){
                                    $item_continue = false;
                                    $item_avialble_qty = (float)$row['_avail_units'];
                                    $item_unit = $row['purchase_unit'];
                                    $item_unit_name = $row['purchase_unit_name'];
                                    $item_unit_equalance = $row['purchase_unit_equalance'];
                                    $item_stats = isset($row['stats']) ? json_decode($row['stats'],true) : [];

                                    if(!empty($item_stats)){
                                        $item_continue = true;
                                        if(!empty($search_unit))
                                        {
                                            if($search_unit == $row['purchase_unit'])
                                            {
                                                $item_unit = $row['purchase_unit'];
                                                $item_unit_name = $row['purchase_unit_name'];
                                                $item_unit_equalance = $row['purchase_unit_equalance'];
                                                $item_continue = true;
                                            }else if($search_unit == $row['sale_unit'])
                                            {
                                                $item_unit = $row['sale_unit'];
                                                $item_unit_name = $row['sale_unit_name'];
                                                $item_unit_equalance = $row['sale_unit_equalance'];
                                                $item_continue = true;
                                            }else if($search_unit == $row['production_unit'])
                                            {
                                                $item_unit = $row['production_unit'];
                                                $item_unit_name = $row['production_unit_name'];
                                                $item_unit_equalance = $row['production_unit_equalance'];
                                                $item_continue = true;
                                            }
                                            else
                                            {
                                                $item_continue = false;
                                            }
                                        }

                                        $item_avialble_qty = $item_avialble_qty * $item_unit_equalance;
                                        if($item_continue == false){continue;}
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name'].' '.$row['details'].' ('.$row['item_id'].')'; ?></td>
                                        <td><?= $row['country']; ?></td>
                                        <td><?= $row['company']; ?></td>
                                        <td><?= $row['details']; ?></td>
                                        <td><?= $item_avialble_qty.'('.$item_unit_name.')'; ?></td>
                                        <?php foreach($warehouses as $row){
                                            $warehouse_available_qty = isset($item_stats['avail_units'][$row['uid']]) ? (float)$item_stats['avail_units'][$row['uid']] : 0;
                                            $warehouse_available_qty = $warehouse_available_qty * $item_unit_equalance;
                                        ?>
                                            <td>
                                                <?php if(!empty($warehouse_available_qty) AND $warehouse_available_qty != 0){?>
                                                    <?= $warehouse_available_qty; ?>
                                                <?php } ?>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php }} ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>