<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'items_ledger'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'items_ledger'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php $item_settings = get_item_settings(); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'items_ledger_report'); ?></h2>

                    <form id="items-ledger-report-search-form" action="<?= url('/reports/items-ledger'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="currency">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                        <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="item">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'item'); ?> --</option>
                                                        <?php foreach($items as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="unit">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'unit'); ?> --</option>
                                                        <?php foreach($units as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_unit == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'opening'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'branch_transfer_in_short'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'ph_transfer_in_short'); ?></th>
                                    <?php } ?>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'received'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'sales'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'return'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'net_sales'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'damage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'b_to_b_out'); ?></th>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'branch_transfer_out_short'); ?></th>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'ph_transfer_out_short'); ?></th>
                                    <?php } ?>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'ava_quantity'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'avg_cost'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'last_cost'); ?></th>
                                    <th class="text-center" style=""><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'profit'); ?></th>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'total_profit'); ?></th>
                                    <?php } ?>

                                    <th class="text-center" style=""><?= print_lang($app_lang,'current_stock'); ?></th>

                                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'total_by_m2'); ?></th>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'width'); ?></th>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'height'); ?></th>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'length'); ?></th>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'cube_meter'); ?></th>
                                        <th class="text-center" style=""><?= print_lang($app_lang,'total_cube_meter'); ?></th>
                                    <?php } ?>

                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                
                                $opening_units_total = [];
                                $purchase_units_total = [];
                                $production_in_units_total = [];
                                $production_out_units_total = [];
                                $sale_units_total = [];
                                $sale_return_units_total = [];
                                $branch_to_branch_transfer_in_units_total = [];
                                $branch_to_branch_transfer_out_units_total = [];
                                $damage_units_total = [];
                                $expenses_deductions_units_total = [];
                                $transfer_in_pharma_total = [];
                                $transfer_out_pharma_total = [];
                                $transfer_in_units_total = [];
                                $transfer_out_units_total = [];
                                $branch_transfer_in_units_total = [];
                                $branch_transfer_out_units_total = [];
                                $total_stock_in_total = [];
                                $total_stock_out_total = [];
                                $total_ava_units_total = [];
                                $total_ava_units_amount_total = [];
                                $avg_cost_total = [];
                                $last_cost_total = [];
                                $first_cost_total = [];
                                $sales_price_total = [];
                                $last_profit_total = [];
                                $total_profit_total = [];
                                $total_by_m2_total = [];
                                $item_width_total = [];
                                $item_height_total = [];
                                $item_length_total = [];
                                $item_cube_meter_total = [];
                                $item_total_cube_meter_total = [];
                                $item_current_stock_total = [];

                                $empty_inventory = [
                                    'opening_units' => 0,
                                    'purchase_units' => 0,
                                    'purchase_bonus_units' => 0,
                                    'production_in_units' => 0,
                                    'production_out_units' => 0,
                                    'sale_units' => 0,
                                    'sale_bonus_units' => 0,
                                    'sale_return_units' => 0,
                                    'sale_return_bonus_units' => 0,
                                    'branch_to_branch_transfer_in_units' => 0,
                                    'branch_to_branch_transfer_out_units' => 0,
                                    'damage_units' => 0,
                                    'expenses_deductions_units' => 0,
                                    'transfer_in_pharma' => 0,
                                    'transfer_in_pharma_bonus' => 0,
                                    'transfer_out_pharma' => 0,
                                    'transfer_out_pharma_bonus' => 0,
                                    'transfer_in_units' => 0,
                                    'transfer_out_units' => 0,
                                    'branch_transfer_in_units' => 0,
                                    'branch_transfer_out_units' => 0,
                                    'total_stock_in' => 0,
                                    'total_stock_out' => 0,
                                ];
                                $i = 1;
                                foreach($pageData as $item){
                                    $item_db_record = $item;
                                    $item_db_record_stats = json_decode($item_db_record['stats'],true);
                                    $item_avg_cost = (float)$item_db_record_stats['avg_cost'];
                                    $item_first_cost = (float)$item_db_record['cost'];
                                    $item_last_cost = (float)$item_db_record_stats['last_cost'];
                                    $item_last_profit = (float)$item_db_record_stats['last_profit'];
                                    $item_total_profit = (float)$item_db_record_stats['total_profit'];
                                    $item_sale_price = (float)$item_db_record_stats['avg_cost'] + (float)$item_db_record_stats['last_profit'];
                                    $rate_to_calculate = $item_avg_cost;
                                    $row = isset($item_inventory_query[$item['uid']]) ? $item_inventory_query[$item['uid']] : $empty_inventory;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $item['name']; ?></td>
                                        
                                        <?php

                                        $before_filter_in_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_stock_in'] : 0;
                                        $before_filter_in_bonus_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_bonus_in'] : 0;
                                        $before_filter_out_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_stock_out'] : 0;
                                        $before_filter_out_bonus_units = isset($before_filter_query[$item['uid']]) ? $before_filter_query[$item['uid']]['total_bonus_out'] : 0;
                                        $before_filter_ava_units = $before_filter_in_units + $before_filter_in_bonus_units - $before_filter_out_units - $before_filter_out_bonus_units;

                                        $opening_units = (float)$row['opening_units'] + $before_filter_ava_units;

                                        $purchase_units_in = (float)$row['purchase_units'];
                                        $purchase_bonus_in = (float)$row['purchase_bonus_units'];

                                        $purchase_units = $purchase_units_in + $purchase_bonus_in;

                                        $production_in_units = (float)$row['production_in_units'];
                                        $production_out_units = (float)$row['production_out_units'];

                                        $sale_units_in = (float)$row['sale_units'];
                                        $sale_bonus_in = (float)$row['sale_bonus_units'];

                                        $sale_units = $sale_units_in + $sale_bonus_in;

                                        $sale_return_units_in = (float)$row['sale_return_units'];
                                        $sale_return_bonus_in = (float)$row['sale_return_bonus_units'];

                                        $sale_return_units = $sale_return_units_in + $sale_return_bonus_in;

                                        $branch_to_branch_transfer_in_units = (float)$row['branch_to_branch_transfer_in_units'];
                                        $branch_to_branch_transfer_out_units = (float)$row['branch_to_branch_transfer_out_units'];

                                        $damage_units = (float)$row['damage_units'];

                                        $expenses_deductions_units = (float)$row['expenses_deductions_units'];

                                        $transfer_in_pharma_units = (float)$row['transfer_in_pharma'];
                                        $transfer_in_pharma_bonus = (float)$row['transfer_in_pharma_bonus'];

                                        $transfer_in_pharma = $transfer_in_pharma_units + $transfer_in_pharma_bonus;

                                        $transfer_out_pharma_units = (float)$row['transfer_out_pharma'];
                                        $transfer_out_pharma_bonus = (float)$row['transfer_out_pharma_bonus'];

                                        $transfer_out_pharma = $transfer_out_pharma_units + $transfer_out_pharma_bonus;

                                        $transfer_in_units = (float)$row['transfer_in_units'];

                                        $transfer_out_units = (float)$row['transfer_out_units'];

                                        $branch_transfer_in_units = (float)$row['branch_transfer_in_units'];

                                        $branch_transfer_out_units = (float)$row['branch_transfer_out_units'];

                                        $total_stock_in_units_calculate = $opening_units + $purchase_units + $branch_to_branch_transfer_in_units + $transfer_in_units + $branch_transfer_in_units + $sale_return_units + $production_in_units;
                                        $total_stock_out_units_calculate = $sale_units + $damage_units + $expenses_deductions_units + $branch_to_branch_transfer_out_units + $transfer_out_units + $branch_transfer_out_units + $production_out_units;

                                        $total_ava_units = $total_stock_in_units_calculate - $total_stock_out_units_calculate;
                                        $total_ava_units_amount = $total_ava_units * $rate_to_calculate;

                                        $currency_symbol = array_key_exists($search_currency, $currencies) ? $currencies[$search_currency]['symbol'] : NULL;
                                        if(!empty($search_currency))
                                        {
                                            $item_avg_cost = amount_conversion($item_avg_cost, $item_db_record['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_first_cost = amount_conversion($item_first_cost, $item_db_record['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_cost = amount_conversion($item_last_cost, $item_db_record['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_sale_price = amount_conversion($item_sale_price, $item_db_record['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        if(!empty($search_unit))
                                        {
                                            if($item['purchase_unit'] == $search_unit){ $unit_identifier = 'purchase'; }
                                            else if($item['sale_unit'] == $search_unit){ $unit_identifier = 'sale'; }
                                            else if($item['production_unit'] == $search_unit){ $unit_identifier = 'production'; }
                                            else{ $unit_identifier = 'purchase'; }

                                            $item_avg_cost = amount_unit_based_conversion($item,$unit_identifier,$item_avg_cost);
                                            $item_last_cost = amount_unit_based_conversion($item,$unit_identifier,$item_last_cost);
                                            $item_first_cost = amount_unit_based_conversion($item,$unit_identifier,$item_first_cost);
                                            $item_sale_price = amount_unit_based_conversion($item,$unit_identifier,$item_sale_price);

                                            $opening_units = unit_based_conversion($item,$unit_identifier,$opening_units);
                                            $purchase_units = unit_based_conversion($item,$unit_identifier,$purchase_units);
                                            $production_in_units = unit_based_conversion($item,$unit_identifier,$production_in_units);
                                            $production_out_units = unit_based_conversion($item,$unit_identifier,$production_out_units);
                                            $sale_units = unit_based_conversion($item,$unit_identifier,$sale_units);
                                            $sale_return_units = unit_based_conversion($item,$unit_identifier,$sale_return_units);
                                            $branch_to_branch_transfer_in_units = unit_based_conversion($item,$unit_identifier,$branch_to_branch_transfer_in_units);
                                            $branch_to_branch_transfer_out_units = unit_based_conversion($item,$unit_identifier,$branch_to_branch_transfer_out_units);
                                            $damage_units = unit_based_conversion($item,$unit_identifier,$damage_units);
                                            $expenses_deductions_units = unit_based_conversion($item,$unit_identifier,$expenses_deductions_units);
                                            $transfer_in_pharma = unit_based_conversion($item,$unit_identifier,$transfer_in_pharma);
                                            $transfer_out_pharma = unit_based_conversion($item,$unit_identifier,$transfer_out_pharma);
                                            $transfer_in_units = unit_based_conversion($item,$unit_identifier,$transfer_in_units);
                                            $transfer_out_units = unit_based_conversion($item,$unit_identifier,$transfer_out_units);
                                            $branch_transfer_in_units = unit_based_conversion($item,$unit_identifier,$branch_transfer_in_units);
                                            $branch_transfer_out_units = unit_based_conversion($item,$unit_identifier,$branch_transfer_out_units);

                                            $total_stock_in_units_calculate = $opening_units + $purchase_units + $branch_to_branch_transfer_in_units + $transfer_in_units + $branch_transfer_in_units + $sale_return_units + $production_in_units;
                                            $total_stock_out_units_calculate = $sale_units + $damage_units + $expenses_deductions_units + $branch_to_branch_transfer_out_units + $transfer_out_units + $branch_transfer_out_units + $production_out_units;

                                            $total_ava_units = $total_stock_in_units_calculate - $total_stock_out_units_calculate;
                                            $total_ava_units_amount = $total_ava_units * $rate_to_calculate;
                                        }

                                        $item_width = (float)$item['width'];
                                        $item_height = (float)$item['height'];
                                        $item_length = (float)$item['length'];
                                        $item_cube_meter = $item_width * $item_height;
                                        $item_total_cube_meter = $item_cube_meter * $total_ava_units;
                                        $total_by_m2 = $item_cube_meter * $total_ava_units;

                                        if($item_settings['item_measurements'] == 'get')
                                        {
                                            $item_current_stock = $total_by_m2 * $item_avg_cost;
                                            $item_current_stock_amount = $item_current_stock * $rate_to_calculate;
                                        }
                                        else
                                        {
                                            $item_current_stock = $total_ava_units * $item_avg_cost;
                                            $item_current_stock_amount = $item_current_stock * $rate_to_calculate;
                                        }

                                        ?>

                                        <td><?= round_decimels_digits( $opening_units ); $opening_units_total[] = $opening_units; ?></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_in_units ); $branch_transfer_in_units_total[] = $branch_transfer_in_units; ?></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $transfer_in_pharma ); $transfer_in_pharma_total[] = $transfer_in_pharma; ?></td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits( $purchase_units ); $purchase_units_total[] = $purchase_units; ?></td>
                                        <td><?= round_decimels_digits( $sale_units ); $sale_units_total[] = $sale_units; ?></td>
                                        <td><?= round_decimels_digits( $sale_return_units ); $sale_return_units_total[] = $sale_return_units; ?></td>
                                        <td><?= round_decimels_digits( $sale_units - $sale_return_units ); $net_sales_total[] = $sale_units - $sale_return_units; ?></td>
                                        <td><?= round_decimels_digits( $damage_units ); $damage_units_total[] = $damage_units; ?></td>
                                        <td><?= round_decimels_digits( $branch_to_branch_transfer_in_units ); $branch_to_branch_transfer_in_units_total[] = $branch_to_branch_transfer_in_units; ?></td>
                                        <td><?= round_decimels_digits( $branch_to_branch_transfer_out_units ); $branch_to_branch_transfer_out_units_total[] = $branch_to_branch_transfer_out_units; ?></td>
                                        <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                            <td><?= round_decimels_digits( $branch_transfer_out_units ); $branch_transfer_out_units_total[] = $branch_transfer_out_units; ?></td>
                                        <?php } ?>
                                        <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                            <td><?= round_decimels_digits( $transfer_out_pharma ); $transfer_out_pharma_total[] = $transfer_out_pharma; ?></td>
                                        <?php } ?>
                                        <td><?= round_decimels_digits( $total_ava_units ); $total_ava_units_total[] = $total_ava_units; ?></td>

                                        <td><?= round_decimels_digits( $item_avg_cost ); $avg_cost_total[] = $item_avg_cost; ?></td>
                                        <td><?= round_decimels_digits( $item_last_cost ); $last_cost_total[] = $item_last_cost; ?></td>
                                        <td><?= round_decimels_digits( $item_sale_price ); $sales_price_total[] = $item_sale_price; ?></td>
                                        <?php if(check_user_access('system_profit') === TRUE){ ?>
                                            <td><?= round_decimels_digits( $item_last_profit ); $last_profit_total[] = $item_last_profit; ?></td>
                                            <td><?= round_decimels_digits( $item_total_profit ); $total_profit_total[] = $item_total_profit; ?></td>
                                        <?php } ?>

                                        <td><?= round_decimels_digits( $item_current_stock ); $item_current_stock_total[] = $item_current_stock; ?></td>

                                        <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                            <td><?= round_decimels_digits( $total_by_m2 ); $total_by_m2_total[] = $total_by_m2; ?></td>
                                            <td><?= round_decimels_digits( $item_width ); $item_width_total[] = $item_width; ?></td>
                                            <td><?= round_decimels_digits( $item_height ); $item_height_total[] = $item_height; ?></td>
                                            <td><?= round_decimels_digits( $item_length ); $item_length_total[] = $item_length; ?></td>
                                            <td><?= round_decimels_digits( $item_cube_meter ); $item_cube_meter_total[] = $item_cube_meter; ?></td>
                                            <td><?= round_decimels_digits( $item_total_cube_meter ); $item_total_cube_meter_total[] = $item_total_cube_meter; ?></td>
                                        <?php } ?>

                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>

                                    <td><?= round_decimels_digits( array_sum($opening_units_total) ); ?></td>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <td><?= round_decimels_digits( array_sum($branch_transfer_in_units_total) ); ?></td>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <td><?= round_decimels_digits( array_sum($transfer_in_pharma_total) ); ?></td>
                                    <?php } ?>
                                    <td><?= round_decimels_digits( array_sum($purchase_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($sale_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($sale_return_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($sale_units_total) - array_sum($sale_return_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($damage_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($branch_to_branch_transfer_in_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($branch_to_branch_transfer_out_units_total) ); ?></td>
                                    <?php if($item_settings['transfer'] == 'b_transfer'){ ?>
                                        <td><?= round_decimels_digits( array_sum($branch_transfer_out_units_total) ); ?></td>
                                    <?php } ?>
                                    <?php if($item_settings['transfer'] == 'n_transfer'){ ?>
                                        <td><?= round_decimels_digits( array_sum($transfer_out_pharma_total) ); ?></td>
                                    <?php } ?>
                                    <td><?= round_decimels_digits( array_sum($total_ava_units_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($avg_cost_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($last_cost_total) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($sales_price_total) ); ?></td>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <td><?= round_decimels_digits( array_sum($last_profit_total) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_profit_total) ); ?></td>
                                    <?php } ?>
                                    <td><?= round_decimels_digits( array_sum($item_current_stock_total) ); ?></td>

                                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                        <td><?= round_decimels_digits( array_sum($total_by_m2_total) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($item_width_total) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($item_height_total) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($item_length_total) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($item_cube_meter_total) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($item_total_cube_meter_total) ); ?></td>
                                    <?php } ?>

                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>