<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'items_ledger'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'items_ledger'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>

<?php $item_settings = get_item_settings(); ?>

<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'items_ledger_report'); ?></h2>

                    <form id="items-ledger-report-search-form" action="<?= url('/reports/items-ledger'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="currency">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                                        <?php $currency_data = array(); foreach($currencies as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ $currency_data = $row; echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="item">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'item'); ?> --</option>
                                                        <?php foreach($items as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="unit">
                                                        <option value="" selected="">-- <?= print_lang($app_lang,'unit'); ?> --</option>
                                                        <?php foreach($units as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_unit == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 50px;"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'item'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'opening'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'branch_transfer_in_short'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'received'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'sales'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'return'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'net_sales'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'damage'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'branch_transfer_out_short'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'ava_quantity'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'avg_cost'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'first_cost'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'last_cost'); ?></th>
                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'sale_price'); ?></th>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'profit'); ?></th>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'total_profit'); ?></th>
                                    <?php } ?>

                                    <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'current_stock'); ?></th>

                                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'total_by_m2'); ?></th>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'width'); ?></th>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'height'); ?></th>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'length'); ?></th>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'cube_meter'); ?></th>
                                        <th class="text-center" style="min-width: 100px;"><?= print_lang($app_lang,'total_cube_meter'); ?></th>
                                    <?php } ?>

                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                
                                $i = 1;

                                $total_of_item_opening_units = array();
                                $total_of_branch_transfer_in = array();
                                $total_of_receiving_units = array();
                                $total_of_sale_units = array();
                                $total_of_sale_return_units = array();
                                $total_of_net_sale_units = array();
                                $total_of_damage_units = array();
                                $total_of_branch_transfer_out = array();
                                $total_of_avail_units = array();
                                $total_of_item_avg_cost = array();
                                $total_of_item_first_cost = array();
                                $total_of_item_last_cost = array();
                                $total_of_item_sale_price = array();
                                $total_of_item_last_profit = array();
                                $total_of_item_total_profit = array();
                                $total_of_item_current_stock = array();
                                $total_of_total_by_m2 = array();
                                $total_of_item_width = array();
                                $total_of_item_height = array();
                                $total_of_item_length = array();
                                $total_of_item_cube_meter = array();
                                $total_of_item_total_cube_meter = array();

                                foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name']; ?></td>
                                        
                                        <?php
                                        $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                        // will have items opening stats before from date if from date set in search filter
                                        $item_opening_units = array_key_exists($row['uid'], $opening_stock_units) ? sum_up_array_values($opening_stock_units[$row['uid']]['stats']['avail_units']) : 0;
                                        $receiving_units = sum_up_array_values($row['stats']['receiving_units']);
                                        $branch_transfer_in_units = sum_up_array_values($row['stats']['branch_transfer_in_units']);
                                        $sale_units = sum_up_array_values($row['stats']['sale_units']);
                                        $sale_return_units = 0;
                                        $net_sale_units = sum_up_array_values($row['stats']['sale_units']);
                                        $damage_units = sum_up_array_values($row['stats']['damage_units']);
                                        $branch_transfer_out_units = sum_up_array_values($row['stats']['branch_transfer_out_units']);
                                        $avail_units = sum_up_array_values($row['stats']['avail_units']);

                                        $item_avg_cost = $row['stats']['avg_cost'];
                                        $item_first_cost = $row['cost'];
                                        $item_last_cost = $row['stats']['last_cost'];
                                        $item_sale_price = $row['stats']['avg_cost'] + $row['stats']['last_profit'];
                                        $item_last_profit = $row['stats']['last_profit'];
                                        $item_total_profit = $row['stats']['total_profit'];
                                        
                                        if(!empty($search_from))
                                        {
                                            $receiving_units = $receiving_units + $item_opening_units - $row['opening_stock'];
                                            $avail_units = $avail_units + $item_opening_units - $row['opening_stock'];
                                        }

                                        if(!empty($search_currency))
                                        {
                                            $item_avg_cost = amount_conversion($item_avg_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_first_cost = amount_conversion($item_first_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_cost = amount_conversion($item_last_cost, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_sale_price = amount_conversion($item_sale_price, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_last_profit = amount_conversion($item_last_profit, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                            $item_total_profit = amount_conversion($item_total_profit, $row['currency_usd_equalance'], $currency_data['usd_equalance']);
                                        }

                                        if(!empty($search_unit))
                                        {
                                            if($row['purchase_unit'] == $search_unit){ $unit_identifier = 'purchase'; }
                                            else if($row['sale_unit'] == $search_unit){ $unit_identifier = 'sale'; }
                                            else if($row['production_unit'] == $search_unit){ $unit_identifier = 'production'; }
                                            else{ $unit_identifier = 'purchase'; }

                                            $item_avg_cost = amount_unit_based_conversion($row,$unit_identifier,$item_avg_cost);
                                            $item_first_cost = amount_unit_based_conversion($row,$unit_identifier,$item_first_cost);
                                            $item_last_cost = amount_unit_based_conversion($row,$unit_identifier,$item_last_cost);
                                            $item_sale_price = amount_unit_based_conversion($row,$unit_identifier,$item_sale_price);
                                            $item_last_profit = amount_unit_based_conversion($row,$unit_identifier,$item_last_profit);
                                            $item_total_profit = amount_unit_based_conversion($row,$unit_identifier,$item_total_profit);

                                            $item_opening_units = unit_based_conversion($row,$unit_identifier,$item_opening_units);
                                            $branch_transfer_in_units = unit_based_conversion($row,$unit_identifier,$branch_transfer_in_units);
                                            $receiving_units = unit_based_conversion($row,$unit_identifier,$receiving_units);
                                            $sale_units = unit_based_conversion($row,$unit_identifier,$sale_units);
                                            $sale_return_units = unit_based_conversion($row,$unit_identifier,$sale_return_units);
                                            $net_sale_units = unit_based_conversion($row,$unit_identifier,$net_sale_units);
                                            $damage_units = unit_based_conversion($row,$unit_identifier,$damage_units);
                                            $branch_transfer_out_units = unit_based_conversion($row,$unit_identifier,$branch_transfer_out_units);
                                            $avail_units = unit_based_conversion($row,$unit_identifier,$avail_units);
                                        }

                                        $item_width = (float)$row['width'];
                                        $item_height = (float)$row['height'];
                                        $item_length = (float)$row['length'];
                                        $item_cube_meter = $item_width * $item_height;
                                        $item_total_cube_meter = $item_cube_meter * $avail_units;
                                        $total_by_m2 = $item_cube_meter * $avail_units;

                                        if($item_settings['item_measurements'] == 'get')
                                        {
                                            $item_current_stock = $total_by_m2 * $item_avg_cost;
                                        }
                                        else
                                        {
                                            $item_current_stock = $avail_units * $item_avg_cost;
                                        }

                                        ?>

                                        <td><?= round_decimels_digits( $item_opening_units ); $total_of_item_opening_units[] = $item_opening_units; ?></td>
                                        <td><?= round_decimels_digits( $branch_transfer_in_units ); $total_of_branch_transfer_in[] = $branch_transfer_in_units; ?></td>
                                        <td><?= round_decimels_digits( $receiving_units ); $total_of_receiving_units[] = $receiving_units; ?></td>
                                        <td><?= round_decimels_digits( $sale_units ); $total_of_sale_units[] = $sale_units; ?></td>
                                        <td><?= round_decimels_digits( $sale_return_units ); $total_of_sale_return_units[] = $sale_return_units; ?></td>
                                        <td><?= round_decimels_digits( $net_sale_units ); $total_of_net_sale_units[] = $net_sale_units; ?></td>
                                        <td><?= round_decimels_digits( $damage_units ); $total_of_damage_units[] = $damage_units; ?></td>
                                        <td><?= round_decimels_digits( $branch_transfer_out_units ); $total_of_branch_transfer_out[] = $branch_transfer_out_units; ?></td>
                                        <td><?= round_decimels_digits( $avail_units ); $total_of_avail_units[] = $avail_units; ?></td>

                                        <td><?= round_decimels_digits( $item_avg_cost ); $total_of_item_avg_cost[] = $item_avg_cost; ?></td>
                                        <td><?= round_decimels_digits( $item_first_cost ); $total_of_item_first_cost[] = $item_first_cost; ?></td>
                                        <td><?= round_decimels_digits( $item_last_cost ); $total_of_item_last_cost[] = $item_last_cost; ?></td>
                                        <td><?= round_decimels_digits( $item_sale_price ); $total_of_item_sale_price[] = $item_sale_price; ?></td>
                                        <?php if(check_user_access('system_profit') === TRUE){ ?>
                                            <td><?= round_decimels_digits( $item_last_profit ); $total_of_item_last_profit[] = $item_last_profit; ?></td>
                                            <td><?= round_decimels_digits( $item_total_profit ); $total_of_item_total_profit[] = $item_total_profit; ?></td>
                                        <?php } ?>

                                        <td><?= round_decimels_digits( $item_current_stock ); $total_of_item_current_stock[] = $item_current_stock; ?></td>

                                        <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                            <td><?= round_decimels_digits( $total_by_m2 ); $total_of_total_by_m2[] = $total_by_m2; ?></td>
                                            <td><?= round_decimels_digits( $item_width ); $total_of_item_width[] = $item_width; ?></td>
                                            <td><?= round_decimels_digits( $item_height ); $total_of_item_height[] = $item_height; ?></td>
                                            <td><?= round_decimels_digits( $item_length ); $total_of_item_length[] = $item_length; ?></td>
                                            <td><?= round_decimels_digits( $item_cube_meter ); $total_of_item_cube_meter[] = $item_cube_meter; ?></td>
                                            <td><?= round_decimels_digits( $item_total_cube_meter ); $total_of_item_total_cube_meter[] = $item_total_cube_meter; ?></td>
                                        <?php } ?>

                                    </tr>
                                <?php } ?>

                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>

                                    <td><?= round_decimels_digits( array_sum($total_of_item_opening_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_branch_transfer_in) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_receiving_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_sale_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_sale_return_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_net_sale_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_damage_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_branch_transfer_out) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_avail_units) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_item_avg_cost) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_item_first_cost) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_item_last_cost) ); ?></td>
                                    <td><?= round_decimels_digits( array_sum($total_of_item_sale_price) ); ?></td>
                                    <?php if(check_user_access('system_profit') === TRUE){ ?>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_last_profit) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_total_profit) ); ?></td>
                                    <?php } ?>
                                    <td><?= round_decimels_digits( array_sum($total_of_item_current_stock) ); ?></td>

                                    <?php if($item_settings['item_measurements'] == 'get'){ ?>
                                        <td><?= round_decimels_digits( array_sum($total_of_total_by_m2) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_width) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_height) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_length) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_cube_meter) ); ?></td>
                                        <td><?= round_decimels_digits( array_sum($total_of_item_total_cube_meter) ); ?></td>
                                    <?php } ?>

                                </tr>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>