<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'items_token_report_view_title'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'items_token_report_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'items_token_report_view_title'); ?></h2>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'items_token_report_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_token_report_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_token_report_thead_token_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_token_report_thead_token_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'items_token_report_thead_token_available'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $i = 1;
                                $total_in = [];
                                $total_out = [];
                                $total_ava = [];
                                foreach($items as $row){
                                    $item_stats = isset($row['stats']) ? json_decode($row['stats'],true) : [];

                                    if(!empty($item_stats)){
                                        $token_in = isset($item_stats['item_token_in_units']) ? array_sum($item_stats['item_token_in_units']) : 0;
                                        $token_out = isset($item_stats['item_token_out_units']) ? array_sum($item_stats['item_token_out_units']) : 0;
                                        $avail_units = $token_in - $token_out;
                                        if($token_in == 0 AND $token_out == 0){continue;}
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['name'].' '.$row['details'].' ('.$row['item_id'].')'; ?></td>
                                        <td><?= amount_number_format_0($token_in); $total_in[] = $token_in; ?></td>
                                        <td><?= amount_number_format_0($token_out); $total_out[] = $token_out; ?></td>
                                        <td><?= amount_number_format_0($avail_units); $total_ava[] = $avail_units; ?></td>
                                    </tr>
                                <?php }} ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td><strong><?= amount_number_format_0(array_sum($total_in)); ?></strong></td>
                                        <td><strong><?= amount_number_format_0(array_sum($total_out)); ?></strong></td>
                                        <td><strong><?= amount_number_format_0(array_sum($total_ava)); ?></strong></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>