<style>
    .pagination {
        margin: 0 !important;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'marketers_rep_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'marketers_rep_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'marketers_rep_view_title'); ?></h2>

                    <form id="marketers-search-form" action="<?= url('/reports/marketers'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select class="form-control chosen-select" name="marketer">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'marketer'); ?> --</option>
                                            <?php foreach($marketers as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_marketer == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'services_mod_view_filter_from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'services_mod_view_filter_to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_rep_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_rep_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_rep_view_thead_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_rep_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_rep_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'marketers_rep_view_thead_amount'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $i = 1; $total = array(); foreach($pageData as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['date'])[0]); ?></td>
                                        <td><?php echo array_key_exists($row['marketer'],$marketers) ? $marketers[$row['marketer']]['name']." ".$marketers[$row['marketer']]['last_name'] : NULL;?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?php echo array_key_exists($row['currency'],$currencies) ? $currencies[$row['currency']]['name'] : NULL;?></td>
                                        <td><?php echo $row['amount']; $total[] = $row['amount']; ?></td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td><strong><?= $i++; ?></strong></td>
                                    <td><strong><?= display_true_date(date("Y-m-d")); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td>--</td>
                                    <td>--</td>
                                    <td><strong><?= array_sum($total); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>