<?php $item_settings = get_item_settings(); ?>

<!-- <style>
    @media print {
        ::-webkit-scrollbar {
            display: none;
        }
        #dynamic-content-container{background: #fff;}
        .navbar-default.navbar-static-side{display: none !important;}
        #page-wrapper{margin: 0px !important; padding: 0 !important;}
        .row.border-bottom{display: none !important;}
        .footer.fixed{display: none;}
        .ibox-content{padding: 0 !important;}
        body {
        -webkit-print-color-adjust:exact;
        background: #fff;
        }
    }
</style> -->
<style type="text/css">
    .print:last-child {
         page-break-after: auto;
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'expiry_report_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'expiry_report_title'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
        </div>
    </div>
</div>



<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <!-- spinner -->
                    <div class="sk-spinner sk-spinner-three-bounce">
                        <div class="sk-bounce1"></div>
                        <div class="sk-bounce2"></div>
                        <div class="sk-bounce3"></div>
                    </div>
                    <!-- spinner -->

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'expiry_report_title'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_item'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_batch'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'batch_rep_view_thead_mfg'); ?></th>
                                    <th class="text-center" style="min-width: 70px;"><?= print_lang($app_lang,'batch_rep_view_thead_expiry'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_return'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tin'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tout'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_b_to_b_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_b_to_b_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_damage'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_production_in'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_production_out'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_ava'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_stocki_tp'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch_rep_view_thead_value'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php 
                                $i = 1; 
                                $active_branch_id = active_branch_id();
                                $stock_in = 0;
                                $stock_out = 0;
                                $bonus_in = 0;
                                $bonus_out = 0;
                                $cost = 0;
                                $value = 0;
                                $stock_ava = 0;
                                $total_stock = array();
                                $purchases_total = array();
                                $sales_total = array();
                                $returns_total = array();
                                $transfer_in_total = array();
                                $transfer_out_total = array();
                                $b_to_b_in_total = array();
                                $b_to_b_out_total = array();
                                $production_in_total = array();
                                $production_out_total = array();
                                $damage_total = array();
                                $available_total = array();
                                $tp_total = array();

                                foreach($pageData as $row){
                                    // print_rr($row);
                                    if($row['available'] > 0){
                                        $item = fetch_table_where('items','uid',$row['item'],true);
                                        $item_currency = $item['currency'];
                                        $item_currency_usd_equalance = (float)$item['currency_usd_equalance'];

                                        // check for expiry alert... if expiry date and expiry alert is not empty
                                        if(!empty($row['expiry']) AND !empty($item['expiry_alert']))
                                        {
                                            $today = date('Y-m-d');
                                            $today = new DateTime($today);
                                            $expiry_date_batch = new DateTime($row['expiry']);
                                            // if expiry date is passed than it will not include in near expiry stock
                                            if($today <= $expiry_date_batch)
                                            {
                                                $_item_expiry_date = $row['expiry'];
                                                $_item_expiry_alert = (int)$item['expiry_alert'];
                                                // get the date for expiry alert
                                                $_item_expiry_alert_date = get_x_months_before_date($_item_expiry_date,$_item_expiry_alert);

                                                // check if it exist in expiry alert
                                                if(check_for_expiry_date($_item_expiry_alert_date) === FALSE){
                                                $unit = array_key_exists($row['unit'], $units) ? $units[$row['unit']]['short'] : NULL;
                                    
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['item_name']; ?></td>
                                        <td><?= $unit; ?></td>
                                        <td><?= $row['batch']; ?></td>
                                        <td><?php if(!empty($row['mfg'])){echo display_true_date($row['mfg']);}; ?></td>
                                        <td><?php if(!empty($row['expiry'])){echo display_true_date($row['expiry']);}; ?></td>
                                        <td><?= amount_number_format($row['purchases']); $purchases_total[] = $row['purchases'] ?></td>
                                        <td><?= amount_number_format($row['sales']); $sales_total[] = $row['sales'] ?></td>
                                        <td><?= amount_number_format($row['returns']); $returns_total[] = $row['returns'] ?></td>
                                        <td><?= amount_number_format($row['transfer_in']); $transfer_in_total[] = $row['transfer_in'] ?></td>
                                        <td><?= amount_number_format($row['transfer_out']); $transfer_out_total[] = $row['transfer_out'] ?></td>
                                        <td><?= amount_number_format($row['b_to_b_in']); $b_to_b_in_total[] = $row['b_to_b_in'] ?></td>
                                        <td><?= amount_number_format($row['b_to_b_out']); $b_to_b_out_total[] = $row['b_to_b_out'] ?></td>
                                        <td><?= amount_number_format($row['production_in']); $production_in_total[] = $row['production_in'] ?></td>
                                        <td><?= amount_number_format($row['production_out']); $production_out_total[] = $row['production_out'] ?></td>
                                        <td><?= amount_number_format($row['damage']); $damage_total[] = $row['damage'] ?></td>
                                        <td><?= amount_number_format($row['available']); $available_total[] = $row['available'] ?></td>
                                        <td><?= amount_number_format($row['tp']); $tp_total[] = $row['tp'] ?></td>
                                        <td><?= amount_number_format($row['available'] * $row['tp']); $total_stock[] = $row['available'] * $row['tp']; ?></td>
                                    </tr>
                                <?php }}}}} ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= amount_number_format(array_sum($purchases_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($sales_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($returns_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($transfer_in_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($transfer_out_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($b_to_b_in_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($b_to_b_out_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($production_in_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($production_out_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($damage_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($available_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($tp_total)); ?></strong></td>
                                    <td><strong><?= amount_number_format(array_sum($total_stock)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                    
                </div>
            </div>
        </div>
    </div>
</div>