<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'production_report'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'production_report'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'production_report'); ?></h2>

                    <form id="production-report-search-form" action="<?= url('/reports/production'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a href="<?= url('/reports/production').'?from='.display_true_date(date('Y-m-d')).'&to='.display_true_date(date('Y-m-d')); ?>" class="btn btn-primary custom-font-btn-search"><?= print_lang($app_lang,'today'); ?></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'slip'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'raw_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'produced_cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'extra_expenses'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total_raw_cost = array();
                                $total_produced_cost = array();
                                $total_extra_exps = array();
                                $i = 1;
                                foreach($pageData as $row)
                                {
                                    $raw_cost = $row['total_raw_cost'];
                                    $produced_cost = $row['total_produced_cost'];
                                    $total_expenses = $row['total_expenses'];

                                    $total_raw_cost[] = $raw_cost;
                                    $total_produced_cost[] = $produced_cost;
                                    $total_extra_exps[] = $total_expenses;
                                ?>

                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><a target="_blank" href="<?= url('production/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                        <td><?= round_decimels_digits($raw_cost); ?></td>
                                        <td><?= round_decimels_digits($produced_cost); ?></td>
                                        <td><?= round_decimels_digits($total_expenses); ?></td>
                                    </tr>

                                <?php } ?>
                                <tr class="text-center">
                                    <td><?= $i++; ?></td>
                                    <td><?= print_lang($app_lang,'total'); ?></td>
                                    <td><?= display_true_date(date('Y-m-d')); ?></td>
                                    <td></td>
                                    <td><?= round_decimels_digits(array_sum($total_raw_cost)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_produced_cost)); ?></td>
                                    <td><?= round_decimels_digits(array_sum($total_extra_exps)); ?></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>