<?php $item_settings = get_item_settings(); ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'purchases_items_reports'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'purchases_items_reports'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'purchases_items_reports'); ?></h2>

                    <form id="purchases-items-report-search-form" action="<?= url('/reports/purchases-items'); ?>">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="currency">
                                                        <option value="" selected=""><?= print_lang($app_lang,'currency'); ?></option>
                                                        <?php foreach($currencies as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="item">
                                                        <option value="" selected=""><?= print_lang($app_lang,'item'); ?></option>
                                                        <?php foreach($items as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_item == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="type">
                                                        <option value="" selected=""><?= print_lang($app_lang,'type'); ?></option>
                                                        <option value="raw" <?php if($search_type == 'raw'){ echo 'selected="selected"'; } ?>>Raw</option>
                                                        <option value="sales" <?php if($search_type == 'sales'){ echo 'selected="selected"'; } ?>>Sales</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <div class="input-group date">
                                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                                    <select class="form-control chosen-select" name="supplier">
                                                        <option value="" selected=""><?= print_lang($app_lang,'supplier'); ?></option>
                                                        <?php foreach($suppliers as $row){ ?>
                                                            <option value="<?= $row['uid']; ?>" <?php if($search_supplier == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php if($branch_calander == 'persian'){ ?>
                                                    <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                                <?php }else{ ?>
                                                    <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'item_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'category'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'supplier'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'warehouse'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'cost'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'qty'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bonus'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'bonus_value'); ?></th>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <th class="text-center"><?= print_lang($app_lang,'token_thead'); ?></th>
                                    <?php } ?>
                                    <th class="text-center"><?= print_lang($app_lang,'total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'unit'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'batch'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $purchases_total = array();
                                $purchases_items_qty = array();
                                $purchases_items_bonus = array();
                                $purchases_items_bonus_value = array();
                                $total_token_value = array();
                                $purchases_items_cost = array();
                                $purchases_items_total = array();
                                $i = 1;
                                foreach($pageData as $row)
                                {
                                    $item_bonus_value = 0;
                                    $item_details = json_decode($row['items'],true);
                                    foreach($item_details as $inner_row)
                                    {
                                        if(!empty($search_item))
                                        {
                                            if($inner_row['item'] != $search_item){ continue; }
                                        }

                                        $item_total_amount = (float)$inner_row['total'];
                                        $item_qty = (float)$inner_row['qty'];
                                        $item_bonus = (float)$inner_row['bonus'];
                                        $item_cost = (float)$inner_row['cost'];
                                        $item_total = $item_cost * $item_qty;
                                        $item_bonus_value = $item_bonus * $item_cost;

                                        $purchases_items_cost[] = $item_cost;
                                        $purchases_items_qty[] = $item_qty;
                                        $purchases_items_bonus[] = $item_bonus;
                                        $purchases_items_bonus_value[] = $item_bonus_value;
                                        $purchases_items_total[] = $item_total;

                                        $unit_name = NULL;
                                        $item_name = NULL;
                                        $item_category = 'NULL';
                                        if(array_key_exists($inner_row['item'], $items))
                                        {
                                            $selected_item = $items[$inner_row['item']];

                                            // handle type filter here
                                            if(!empty($search_type))
                                            {
                                                if($search_type != $selected_item['type']){ continue; }
                                            }

                                            $item_name = $selected_item['name'];
                                            $item_category = $selected_item['category'];
                                            if($inner_row['unit'] == 'purchase')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['purchase_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['purchase_unit'],$units) ? $units[$selected_item['purchase_unit']]['name'] : NULL;
                                            }
                                            if($inner_row['unit'] == 'sale')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['sale_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['sale_unit'],$units) ? $units[$selected_item['sale_unit']]['name'] : NULL;
                                            }
                                            if($inner_row['unit'] == 'production')
                                            {
                                                $item_total_amount = (float)$item_total_amount * (float)$selected_item['production_unit_equalance'];
                                                $unit_name = array_key_exists($selected_item['production_unit'],$units) ? $units[$selected_item['production_unit']]['name'] : NULL;
                                            }
                                        }
                                        $purchases_total[] = $item_total_amount;
                                    ?>

                                        <tr class="text-center">
                                            <td><?= $i++; ?></td>
                                            <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                            <td><?= $item_name; ?></td>
                                            <td><?= array_key_exists($item_category, $product_categories) ? $product_categories[$item_category]['name'] : NULL; ?></td>
                                            <td><?= array_key_exists($row['supplier'], $accounts_filteration) ? $accounts_filteration[$row['supplier']]['name'] : NULL; ?></td>
                                            <td><a target="_blank" href="<?= url('purchases/invoice').'/'.$row['uid']; ?>">000<?= $row['invoice']; ?></a></td>
                                            <td><?= array_key_exists($inner_row['warehouse'], $warehouses) ? $warehouses[$inner_row['warehouse']]['name'] : NULL; ?></td>
                                            <td><?= array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL; ?></td>
                                            <td><?= round_decimels_digits($item_cost); ?></td>
                                            <td><?= round_decimels_digits($item_qty); ?></td>
                                            <td><?= round_decimels_digits($item_bonus); ?></td>
                                            <td><?= round_decimels_digits($item_bonus_value); ?></td>
                                            <?php if($item_settings['item_token'] == 'enable'){ ?>
                                                <td><?= isset($inner_row['item_token']) ? $inner_row['item_token'] : null; $total_token_value[] = isset($inner_row['item_token']) ? (float)$inner_row['item_token'] : 0; ?></td>
                                            <?php } ?>
                                            <td><?= round_decimels_digits($item_total); ?></td>
                                            <td><?= $unit_name; ?></td>
                                            <td><?= $inner_row['batch']; ?></td>
                                        </tr>

                                    <?php } ?>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($purchases_items_cost)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($purchases_items_qty)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($purchases_items_bonus)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($purchases_items_bonus_value)); ?></strong></td>
                                    <?php if($item_settings['item_token'] == 'enable'){ ?>
                                        <td><strong><?= round_decimels_digits(array_sum($total_token_value)); ?></strong></td>
                                    <?php } ?>
                                    <td><strong><?= round_decimels_digits(array_sum($purchases_items_total)); ?></strong></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>